// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.CustomerInsights.Models
{
    public partial class ConnectorMappingProperties : IUtf8JsonSerializable, IJsonModel<ConnectorMappingProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ConnectorMappingProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ConnectorMappingProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConnectorMappingProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ConnectorMappingProperties)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(FolderPath))
            {
                writer.WritePropertyName("folderPath"u8);
                writer.WriteStringValue(FolderPath);
            }
            if (Optional.IsDefined(FileFilter))
            {
                writer.WritePropertyName("fileFilter"u8);
                writer.WriteStringValue(FileFilter);
            }
            if (Optional.IsDefined(HasHeader))
            {
                writer.WritePropertyName("hasHeader"u8);
                writer.WriteBooleanValue(HasHeader.Value);
            }
            writer.WritePropertyName("errorManagement"u8);
            writer.WriteObjectValue(ErrorManagement, options);
            writer.WritePropertyName("format"u8);
            writer.WriteObjectValue(Format, options);
            writer.WritePropertyName("availability"u8);
            writer.WriteObjectValue(Availability, options);
            writer.WritePropertyName("structure"u8);
            writer.WriteStartArray();
            foreach (var item in Structure)
            {
                writer.WriteObjectValue(item, options);
            }
            writer.WriteEndArray();
            writer.WritePropertyName("completeOperation"u8);
            writer.WriteObjectValue(CompleteOperation, options);
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ConnectorMappingProperties IJsonModel<ConnectorMappingProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConnectorMappingProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ConnectorMappingProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeConnectorMappingProperties(document.RootElement, options);
        }

        internal static ConnectorMappingProperties DeserializeConnectorMappingProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string folderPath = default;
            string fileFilter = default;
            bool? hasHeader = default;
            ConnectorMappingErrorManagement errorManagement = default;
            ConnectorMappingFormat format = default;
            ConnectorMappingAvailability availability = default;
            IList<ConnectorMappingStructure> structure = default;
            ConnectorMappingCompleteOperation completeOperation = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("folderPath"u8))
                {
                    folderPath = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("fileFilter"u8))
                {
                    fileFilter = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("hasHeader"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    hasHeader = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("errorManagement"u8))
                {
                    errorManagement = ConnectorMappingErrorManagement.DeserializeConnectorMappingErrorManagement(property.Value, options);
                    continue;
                }
                if (property.NameEquals("format"u8))
                {
                    format = ConnectorMappingFormat.DeserializeConnectorMappingFormat(property.Value, options);
                    continue;
                }
                if (property.NameEquals("availability"u8))
                {
                    availability = ConnectorMappingAvailability.DeserializeConnectorMappingAvailability(property.Value, options);
                    continue;
                }
                if (property.NameEquals("structure"u8))
                {
                    List<ConnectorMappingStructure> array = new List<ConnectorMappingStructure>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ConnectorMappingStructure.DeserializeConnectorMappingStructure(item, options));
                    }
                    structure = array;
                    continue;
                }
                if (property.NameEquals("completeOperation"u8))
                {
                    completeOperation = ConnectorMappingCompleteOperation.DeserializeConnectorMappingCompleteOperation(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ConnectorMappingProperties(
                folderPath,
                fileFilter,
                hasHeader,
                errorManagement,
                format,
                availability,
                structure,
                completeOperation,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ConnectorMappingProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConnectorMappingProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ConnectorMappingProperties)} does not support writing '{options.Format}' format.");
            }
        }

        ConnectorMappingProperties IPersistableModel<ConnectorMappingProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConnectorMappingProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeConnectorMappingProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ConnectorMappingProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ConnectorMappingProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
