// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.CustomerInsights.Models
{
    /// <summary> Connector mapping property format. </summary>
    public partial class ConnectorMappingFormat
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ConnectorMappingFormat"/>. </summary>
        public ConnectorMappingFormat()
        {
            FormatType = FormatType.TextFormat;
        }

        /// <summary> Initializes a new instance of <see cref="ConnectorMappingFormat"/>. </summary>
        /// <param name="formatType"> The type mapping format. </param>
        /// <param name="columnDelimiter"> The character that signifies a break between columns. </param>
        /// <param name="acceptLanguage"> The oData language. </param>
        /// <param name="quoteCharacter"> Quote character, used to indicate enquoted fields. </param>
        /// <param name="quoteEscapeCharacter"> Escape character for quotes, can be the same as the quoteCharacter. </param>
        /// <param name="arraySeparator"> Character separating array elements. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ConnectorMappingFormat(FormatType formatType, string columnDelimiter, string acceptLanguage, string quoteCharacter, string quoteEscapeCharacter, string arraySeparator, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            FormatType = formatType;
            ColumnDelimiter = columnDelimiter;
            AcceptLanguage = acceptLanguage;
            QuoteCharacter = quoteCharacter;
            QuoteEscapeCharacter = quoteEscapeCharacter;
            ArraySeparator = arraySeparator;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The type mapping format. </summary>
        public FormatType FormatType { get; }
        /// <summary> The character that signifies a break between columns. </summary>
        public string ColumnDelimiter { get; set; }
        /// <summary> The oData language. </summary>
        public string AcceptLanguage { get; set; }
        /// <summary> Quote character, used to indicate enquoted fields. </summary>
        public string QuoteCharacter { get; set; }
        /// <summary> Escape character for quotes, can be the same as the quoteCharacter. </summary>
        public string QuoteEscapeCharacter { get; set; }
        /// <summary> Character separating array elements. </summary>
        public string ArraySeparator { get; set; }
    }
}
