// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.CustomerInsights.Models
{
    internal static partial class CompletionOperationTypeExtensions
    {
        public static string ToSerialString(this CompletionOperationType value) => value switch
        {
            CompletionOperationType.DoNothing => "DoNothing",
            CompletionOperationType.DeleteFile => "DeleteFile",
            CompletionOperationType.MoveFile => "MoveFile",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown CompletionOperationType value.")
        };

        public static CompletionOperationType ToCompletionOperationType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "DoNothing")) return CompletionOperationType.DoNothing;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "DeleteFile")) return CompletionOperationType.DeleteFile;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "MoveFile")) return CompletionOperationType.MoveFile;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown CompletionOperationType value.");
        }
    }
}
