// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.CustomerInsights.Models
{
    internal static partial class CardinalityTypeExtensions
    {
        public static string ToSerialString(this CardinalityType value) => value switch
        {
            CardinalityType.OneToOne => "OneToOne",
            CardinalityType.OneToMany => "OneToMany",
            CardinalityType.ManyToMany => "ManyToMany",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown CardinalityType value.")
        };

        public static CardinalityType ToCardinalityType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "OneToOne")) return CardinalityType.OneToOne;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "OneToMany")) return CardinalityType.OneToMany;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "ManyToMany")) return CardinalityType.ManyToMany;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown CardinalityType value.");
        }
    }
}
