// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CustomerInsights.Models
{
    /// <summary> Type of canonical property value. </summary>
    public readonly partial struct CanonicalPropertyValueType : IEquatable<CanonicalPropertyValueType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CanonicalPropertyValueType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CanonicalPropertyValueType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NumericValue = "Numeric";
        private const string CategoricalValue = "Categorical";
        private const string DerivedCategoricalValue = "DerivedCategorical";
        private const string DerivedNumericValue = "DerivedNumeric";

        /// <summary> Numeric. </summary>
        public static CanonicalPropertyValueType Numeric { get; } = new CanonicalPropertyValueType(NumericValue);
        /// <summary> Categorical. </summary>
        public static CanonicalPropertyValueType Categorical { get; } = new CanonicalPropertyValueType(CategoricalValue);
        /// <summary> DerivedCategorical. </summary>
        public static CanonicalPropertyValueType DerivedCategorical { get; } = new CanonicalPropertyValueType(DerivedCategoricalValue);
        /// <summary> DerivedNumeric. </summary>
        public static CanonicalPropertyValueType DerivedNumeric { get; } = new CanonicalPropertyValueType(DerivedNumericValue);
        /// <summary> Determines if two <see cref="CanonicalPropertyValueType"/> values are the same. </summary>
        public static bool operator ==(CanonicalPropertyValueType left, CanonicalPropertyValueType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CanonicalPropertyValueType"/> values are not the same. </summary>
        public static bool operator !=(CanonicalPropertyValueType left, CanonicalPropertyValueType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CanonicalPropertyValueType"/>. </summary>
        public static implicit operator CanonicalPropertyValueType(string value) => new CanonicalPropertyValueType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CanonicalPropertyValueType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CanonicalPropertyValueType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
