// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.CustomerInsights.Models
{
    internal static partial class CalculationWindowTypeExtensions
    {
        public static string ToSerialString(this CalculationWindowType value) => value switch
        {
            CalculationWindowType.Lifetime => "Lifetime",
            CalculationWindowType.Hour => "Hour",
            CalculationWindowType.Day => "Day",
            CalculationWindowType.Week => "Week",
            CalculationWindowType.Month => "Month",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown CalculationWindowType value.")
        };

        public static CalculationWindowType ToCalculationWindowType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Lifetime")) return CalculationWindowType.Lifetime;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Hour")) return CalculationWindowType.Hour;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Day")) return CalculationWindowType.Day;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Week")) return CalculationWindowType.Week;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Month")) return CalculationWindowType.Month;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown CalculationWindowType value.");
        }
    }
}
