// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.CustomerInsights.Models
{
    /// <summary> The AssignmentPrincipal. </summary>
    public partial class AssignmentPrincipal
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AssignmentPrincipal"/>. </summary>
        /// <param name="principalId"> The principal id being assigned to. </param>
        /// <param name="principalType"> The Type of the principal ID. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="principalId"/> or <paramref name="principalType"/> is null. </exception>
        public AssignmentPrincipal(string principalId, string principalType)
        {
            Argument.AssertNotNull(principalId, nameof(principalId));
            Argument.AssertNotNull(principalType, nameof(principalType));

            PrincipalId = principalId;
            PrincipalType = principalType;
            PrincipalMetadata = new ChangeTrackingDictionary<string, string>();
        }

        /// <summary> Initializes a new instance of <see cref="AssignmentPrincipal"/>. </summary>
        /// <param name="principalId"> The principal id being assigned to. </param>
        /// <param name="principalType"> The Type of the principal ID. </param>
        /// <param name="principalMetadata"> Other metadata for the principal. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AssignmentPrincipal(string principalId, string principalType, IDictionary<string, string> principalMetadata, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PrincipalId = principalId;
            PrincipalType = principalType;
            PrincipalMetadata = principalMetadata;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="AssignmentPrincipal"/> for deserialization. </summary>
        internal AssignmentPrincipal()
        {
        }

        /// <summary> The principal id being assigned to. </summary>
        public string PrincipalId { get; set; }
        /// <summary> The Type of the principal ID. </summary>
        public string PrincipalType { get; set; }
        /// <summary> Other metadata for the principal. </summary>
        public IDictionary<string, string> PrincipalMetadata { get; }
    }
}
