// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.CustomerInsights
{
    internal class RelationshipResourceFormatOperationSource : IOperationSource<RelationshipResourceFormatResource>
    {
        private readonly ArmClient _client;

        internal RelationshipResourceFormatOperationSource(ArmClient client)
        {
            _client = client;
        }

        RelationshipResourceFormatResource IOperationSource<RelationshipResourceFormatResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = RelationshipResourceFormatData.DeserializeRelationshipResourceFormatData(document.RootElement);
            return new RelationshipResourceFormatResource(_client, data);
        }

        async ValueTask<RelationshipResourceFormatResource> IOperationSource<RelationshipResourceFormatResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = RelationshipResourceFormatData.DeserializeRelationshipResourceFormatData(document.RootElement);
            return new RelationshipResourceFormatResource(_client, data);
        }
    }
}
