// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.CustomerInsights
{
    internal class RelationshipLinkResourceFormatOperationSource : IOperationSource<RelationshipLinkResourceFormatResource>
    {
        private readonly ArmClient _client;

        internal RelationshipLinkResourceFormatOperationSource(ArmClient client)
        {
            _client = client;
        }

        RelationshipLinkResourceFormatResource IOperationSource<RelationshipLinkResourceFormatResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = RelationshipLinkResourceFormatData.DeserializeRelationshipLinkResourceFormatData(document.RootElement);
            return new RelationshipLinkResourceFormatResource(_client, data);
        }

        async ValueTask<RelationshipLinkResourceFormatResource> IOperationSource<RelationshipLinkResourceFormatResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = RelationshipLinkResourceFormatData.DeserializeRelationshipLinkResourceFormatData(document.RootElement);
            return new RelationshipLinkResourceFormatResource(_client, data);
        }
    }
}
