// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.CustomerInsights
{
    internal class ProfileResourceFormatOperationSource : IOperationSource<ProfileResourceFormatResource>
    {
        private readonly ArmClient _client;

        internal ProfileResourceFormatOperationSource(ArmClient client)
        {
            _client = client;
        }

        ProfileResourceFormatResource IOperationSource<ProfileResourceFormatResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ProfileResourceFormatData.DeserializeProfileResourceFormatData(document.RootElement);
            return new ProfileResourceFormatResource(_client, data);
        }

        async ValueTask<ProfileResourceFormatResource> IOperationSource<ProfileResourceFormatResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ProfileResourceFormatData.DeserializeProfileResourceFormatData(document.RootElement);
            return new ProfileResourceFormatResource(_client, data);
        }
    }
}
