// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.CustomerInsights
{
    internal class PredictionResourceFormatOperationSource : IOperationSource<PredictionResourceFormatResource>
    {
        private readonly ArmClient _client;

        internal PredictionResourceFormatOperationSource(ArmClient client)
        {
            _client = client;
        }

        PredictionResourceFormatResource IOperationSource<PredictionResourceFormatResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = PredictionResourceFormatData.DeserializePredictionResourceFormatData(document.RootElement);
            return new PredictionResourceFormatResource(_client, data);
        }

        async ValueTask<PredictionResourceFormatResource> IOperationSource<PredictionResourceFormatResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = PredictionResourceFormatData.DeserializePredictionResourceFormatData(document.RootElement);
            return new PredictionResourceFormatResource(_client, data);
        }
    }
}
