// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.CustomerInsights
{
    internal class LinkResourceFormatOperationSource : IOperationSource<LinkResourceFormatResource>
    {
        private readonly ArmClient _client;

        internal LinkResourceFormatOperationSource(ArmClient client)
        {
            _client = client;
        }

        LinkResourceFormatResource IOperationSource<LinkResourceFormatResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = LinkResourceFormatData.DeserializeLinkResourceFormatData(document.RootElement);
            return new LinkResourceFormatResource(_client, data);
        }

        async ValueTask<LinkResourceFormatResource> IOperationSource<LinkResourceFormatResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = LinkResourceFormatData.DeserializeLinkResourceFormatData(document.RootElement);
            return new LinkResourceFormatResource(_client, data);
        }
    }
}
