// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.CustomerInsights.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.CustomerInsights
{
    /// <summary>
    /// A class representing the KpiResourceFormat data model.
    /// The KPI resource format.
    /// </summary>
    public partial class KpiResourceFormatData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="KpiResourceFormatData"/>. </summary>
        public KpiResourceFormatData()
        {
            DisplayName = new ChangeTrackingDictionary<string, string>();
            Description = new ChangeTrackingDictionary<string, string>();
            GroupBy = new ChangeTrackingList<string>();
            GroupByMetadata = new ChangeTrackingList<KpiGroupByMetadata>();
            ParticipantProfilesMetadata = new ChangeTrackingList<KpiParticipantProfilesMetadata>();
            Aliases = new ChangeTrackingList<KpiAlias>();
            Extracts = new ChangeTrackingList<KpiExtract>();
        }

        /// <summary> Initializes a new instance of <see cref="KpiResourceFormatData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="entityType"> The mapping entity type. </param>
        /// <param name="entityTypeName"> The mapping entity name. </param>
        /// <param name="tenantId"> The hub name. </param>
        /// <param name="kpiName"> The KPI name. </param>
        /// <param name="displayName"> Localized display name for the KPI. </param>
        /// <param name="description"> Localized description for the KPI. </param>
        /// <param name="calculationWindow"> The calculation window. </param>
        /// <param name="calculationWindowFieldName"> Name of calculation window field. </param>
        /// <param name="function"> The computation function for the KPI. </param>
        /// <param name="expression"> The computation expression for the KPI. </param>
        /// <param name="unit"> The unit of measurement for the KPI. </param>
        /// <param name="filter"> The filter expression for the KPI. </param>
        /// <param name="groupBy"> the group by properties for the KPI. </param>
        /// <param name="groupByMetadata"> The KPI GroupByMetadata. </param>
        /// <param name="participantProfilesMetadata"> The participant profiles. </param>
        /// <param name="provisioningState"> Provisioning state. </param>
        /// <param name="thresHolds"> The KPI thresholds. </param>
        /// <param name="aliases"> The aliases. </param>
        /// <param name="extracts"> The KPI extracts. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal KpiResourceFormatData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, EntityType? entityType, string entityTypeName, Guid? tenantId, string kpiName, IDictionary<string, string> displayName, IDictionary<string, string> description, CalculationWindowType? calculationWindow, string calculationWindowFieldName, KpiFunction? function, string expression, string unit, string filter, IList<string> groupBy, IReadOnlyList<KpiGroupByMetadata> groupByMetadata, IReadOnlyList<KpiParticipantProfilesMetadata> participantProfilesMetadata, ProvisioningState? provisioningState, KpiThresholds thresHolds, IList<KpiAlias> aliases, IList<KpiExtract> extracts, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            EntityType = entityType;
            EntityTypeName = entityTypeName;
            TenantId = tenantId;
            KpiName = kpiName;
            DisplayName = displayName;
            Description = description;
            CalculationWindow = calculationWindow;
            CalculationWindowFieldName = calculationWindowFieldName;
            Function = function;
            Expression = expression;
            Unit = unit;
            Filter = filter;
            GroupBy = groupBy;
            GroupByMetadata = groupByMetadata;
            ParticipantProfilesMetadata = participantProfilesMetadata;
            ProvisioningState = provisioningState;
            ThresHolds = thresHolds;
            Aliases = aliases;
            Extracts = extracts;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The mapping entity type. </summary>
        public EntityType? EntityType { get; set; }
        /// <summary> The mapping entity name. </summary>
        public string EntityTypeName { get; set; }
        /// <summary> The hub name. </summary>
        public Guid? TenantId { get; }
        /// <summary> The KPI name. </summary>
        public string KpiName { get; }
        /// <summary> Localized display name for the KPI. </summary>
        public IDictionary<string, string> DisplayName { get; }
        /// <summary> Localized description for the KPI. </summary>
        public IDictionary<string, string> Description { get; }
        /// <summary> The calculation window. </summary>
        public CalculationWindowType? CalculationWindow { get; set; }
        /// <summary> Name of calculation window field. </summary>
        public string CalculationWindowFieldName { get; set; }
        /// <summary> The computation function for the KPI. </summary>
        public KpiFunction? Function { get; set; }
        /// <summary> The computation expression for the KPI. </summary>
        public string Expression { get; set; }
        /// <summary> The unit of measurement for the KPI. </summary>
        public string Unit { get; set; }
        /// <summary> The filter expression for the KPI. </summary>
        public string Filter { get; set; }
        /// <summary> the group by properties for the KPI. </summary>
        public IList<string> GroupBy { get; }
        /// <summary> The KPI GroupByMetadata. </summary>
        public IReadOnlyList<KpiGroupByMetadata> GroupByMetadata { get; }
        /// <summary> The participant profiles. </summary>
        public IReadOnlyList<KpiParticipantProfilesMetadata> ParticipantProfilesMetadata { get; }
        /// <summary> Provisioning state. </summary>
        public ProvisioningState? ProvisioningState { get; }
        /// <summary> The KPI thresholds. </summary>
        public KpiThresholds ThresHolds { get; set; }
        /// <summary> The aliases. </summary>
        public IList<KpiAlias> Aliases { get; }
        /// <summary> The KPI extracts. </summary>
        public IList<KpiExtract> Extracts { get; }
    }
}
