// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.CustomerInsights.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.CustomerInsights
{
    public partial class KpiResourceFormatData : IUtf8JsonSerializable, IJsonModel<KpiResourceFormatData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<KpiResourceFormatData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<KpiResourceFormatData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<KpiResourceFormatData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(KpiResourceFormatData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(EntityType))
            {
                writer.WritePropertyName("entityType"u8);
                writer.WriteStringValue(EntityType.Value.ToSerialString());
            }
            if (Optional.IsDefined(EntityTypeName))
            {
                writer.WritePropertyName("entityTypeName"u8);
                writer.WriteStringValue(EntityTypeName);
            }
            if (options.Format != "W" && Optional.IsDefined(TenantId))
            {
                writer.WritePropertyName("tenantId"u8);
                writer.WriteStringValue(TenantId.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(KpiName))
            {
                writer.WritePropertyName("kpiName"u8);
                writer.WriteStringValue(KpiName);
            }
            if (Optional.IsCollectionDefined(DisplayName))
            {
                writer.WritePropertyName("displayName"u8);
                writer.WriteStartObject();
                foreach (var item in DisplayName)
                {
                    writer.WritePropertyName(item.Key);
                    writer.WriteStringValue(item.Value);
                }
                writer.WriteEndObject();
            }
            if (Optional.IsCollectionDefined(Description))
            {
                writer.WritePropertyName("description"u8);
                writer.WriteStartObject();
                foreach (var item in Description)
                {
                    writer.WritePropertyName(item.Key);
                    writer.WriteStringValue(item.Value);
                }
                writer.WriteEndObject();
            }
            if (Optional.IsDefined(CalculationWindow))
            {
                writer.WritePropertyName("calculationWindow"u8);
                writer.WriteStringValue(CalculationWindow.Value.ToSerialString());
            }
            if (Optional.IsDefined(CalculationWindowFieldName))
            {
                writer.WritePropertyName("calculationWindowFieldName"u8);
                writer.WriteStringValue(CalculationWindowFieldName);
            }
            if (Optional.IsDefined(Function))
            {
                writer.WritePropertyName("function"u8);
                writer.WriteStringValue(Function.Value.ToSerialString());
            }
            if (Optional.IsDefined(Expression))
            {
                writer.WritePropertyName("expression"u8);
                writer.WriteStringValue(Expression);
            }
            if (Optional.IsDefined(Unit))
            {
                writer.WritePropertyName("unit"u8);
                writer.WriteStringValue(Unit);
            }
            if (Optional.IsDefined(Filter))
            {
                writer.WritePropertyName("filter"u8);
                writer.WriteStringValue(Filter);
            }
            if (Optional.IsCollectionDefined(GroupBy))
            {
                writer.WritePropertyName("groupBy"u8);
                writer.WriteStartArray();
                foreach (var item in GroupBy)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(GroupByMetadata))
            {
                writer.WritePropertyName("groupByMetadata"u8);
                writer.WriteStartArray();
                foreach (var item in GroupByMetadata)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(ParticipantProfilesMetadata))
            {
                writer.WritePropertyName("participantProfilesMetadata"u8);
                writer.WriteStartArray();
                foreach (var item in ParticipantProfilesMetadata)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState.Value.ToString());
            }
            if (Optional.IsDefined(ThresHolds))
            {
                writer.WritePropertyName("thresHolds"u8);
                writer.WriteObjectValue(ThresHolds, options);
            }
            if (Optional.IsCollectionDefined(Aliases))
            {
                writer.WritePropertyName("aliases"u8);
                writer.WriteStartArray();
                foreach (var item in Aliases)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Extracts))
            {
                writer.WritePropertyName("extracts"u8);
                writer.WriteStartArray();
                foreach (var item in Extracts)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            writer.WriteEndObject();
        }

        KpiResourceFormatData IJsonModel<KpiResourceFormatData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<KpiResourceFormatData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(KpiResourceFormatData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeKpiResourceFormatData(document.RootElement, options);
        }

        internal static KpiResourceFormatData DeserializeKpiResourceFormatData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            EntityType? entityType = default;
            string entityTypeName = default;
            Guid? tenantId = default;
            string kpiName = default;
            IDictionary<string, string> displayName = default;
            IDictionary<string, string> description = default;
            CalculationWindowType? calculationWindow = default;
            string calculationWindowFieldName = default;
            KpiFunction? function = default;
            string expression = default;
            string unit = default;
            string filter = default;
            IList<string> groupBy = default;
            IReadOnlyList<KpiGroupByMetadata> groupByMetadata = default;
            IReadOnlyList<KpiParticipantProfilesMetadata> participantProfilesMetadata = default;
            ProvisioningState? provisioningState = default;
            KpiThresholds thresHolds = default;
            IList<KpiAlias> aliases = default;
            IList<KpiExtract> extracts = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("entityType"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            entityType = property0.Value.GetString().ToEntityType();
                            continue;
                        }
                        if (property0.NameEquals("entityTypeName"u8))
                        {
                            entityTypeName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("tenantId"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            tenantId = property0.Value.GetGuid();
                            continue;
                        }
                        if (property0.NameEquals("kpiName"u8))
                        {
                            kpiName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("displayName"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            Dictionary<string, string> dictionary = new Dictionary<string, string>();
                            foreach (var property1 in property0.Value.EnumerateObject())
                            {
                                dictionary.Add(property1.Name, property1.Value.GetString());
                            }
                            displayName = dictionary;
                            continue;
                        }
                        if (property0.NameEquals("description"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            Dictionary<string, string> dictionary = new Dictionary<string, string>();
                            foreach (var property1 in property0.Value.EnumerateObject())
                            {
                                dictionary.Add(property1.Name, property1.Value.GetString());
                            }
                            description = dictionary;
                            continue;
                        }
                        if (property0.NameEquals("calculationWindow"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            calculationWindow = property0.Value.GetString().ToCalculationWindowType();
                            continue;
                        }
                        if (property0.NameEquals("calculationWindowFieldName"u8))
                        {
                            calculationWindowFieldName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("function"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            function = property0.Value.GetString().ToKpiFunction();
                            continue;
                        }
                        if (property0.NameEquals("expression"u8))
                        {
                            expression = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("unit"u8))
                        {
                            unit = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("filter"u8))
                        {
                            filter = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("groupBy"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<string> array = new List<string>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(item.GetString());
                            }
                            groupBy = array;
                            continue;
                        }
                        if (property0.NameEquals("groupByMetadata"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<KpiGroupByMetadata> array = new List<KpiGroupByMetadata>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(KpiGroupByMetadata.DeserializeKpiGroupByMetadata(item, options));
                            }
                            groupByMetadata = array;
                            continue;
                        }
                        if (property0.NameEquals("participantProfilesMetadata"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<KpiParticipantProfilesMetadata> array = new List<KpiParticipantProfilesMetadata>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(KpiParticipantProfilesMetadata.DeserializeKpiParticipantProfilesMetadata(item, options));
                            }
                            participantProfilesMetadata = array;
                            continue;
                        }
                        if (property0.NameEquals("provisioningState"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            provisioningState = new ProvisioningState(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("thresHolds"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            thresHolds = KpiThresholds.DeserializeKpiThresholds(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("aliases"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<KpiAlias> array = new List<KpiAlias>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(KpiAlias.DeserializeKpiAlias(item, options));
                            }
                            aliases = array;
                            continue;
                        }
                        if (property0.NameEquals("extracts"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<KpiExtract> array = new List<KpiExtract>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(KpiExtract.DeserializeKpiExtract(item, options));
                            }
                            extracts = array;
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new KpiResourceFormatData(
                id,
                name,
                type,
                systemData,
                entityType,
                entityTypeName,
                tenantId,
                kpiName,
                displayName ?? new ChangeTrackingDictionary<string, string>(),
                description ?? new ChangeTrackingDictionary<string, string>(),
                calculationWindow,
                calculationWindowFieldName,
                function,
                expression,
                unit,
                filter,
                groupBy ?? new ChangeTrackingList<string>(),
                groupByMetadata ?? new ChangeTrackingList<KpiGroupByMetadata>(),
                participantProfilesMetadata ?? new ChangeTrackingList<KpiParticipantProfilesMetadata>(),
                provisioningState,
                thresHolds,
                aliases ?? new ChangeTrackingList<KpiAlias>(),
                extracts ?? new ChangeTrackingList<KpiExtract>(),
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<KpiResourceFormatData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<KpiResourceFormatData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(KpiResourceFormatData)} does not support writing '{options.Format}' format.");
            }
        }

        KpiResourceFormatData IPersistableModel<KpiResourceFormatData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<KpiResourceFormatData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeKpiResourceFormatData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(KpiResourceFormatData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<KpiResourceFormatData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
