// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.CustomerInsights.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.CustomerInsights
{
    /// <summary>
    /// A class representing the InteractionResourceFormat data model.
    /// The interaction resource format.
    /// </summary>
    public partial class InteractionResourceFormatData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="InteractionResourceFormatData"/>. </summary>
        public InteractionResourceFormatData()
        {
            Attributes = new ChangeTrackingDictionary<string, IList<string>>();
            Description = new ChangeTrackingDictionary<string, string>();
            DisplayName = new ChangeTrackingDictionary<string, string>();
            LocalizedAttributes = new ChangeTrackingDictionary<string, IDictionary<string, string>>();
            Fields = new ChangeTrackingList<PropertyDefinition>();
            IdPropertyNames = new ChangeTrackingList<string>();
            ParticipantProfiles = new ChangeTrackingList<Participant>();
            DataSourcePrecedenceRules = new ChangeTrackingList<DataSourcePrecedence>();
        }

        /// <summary> Initializes a new instance of <see cref="InteractionResourceFormatData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="attributes"> The attributes for the Type. </param>
        /// <param name="description"> Localized descriptions for the property. </param>
        /// <param name="displayName"> Localized display names for the property. </param>
        /// <param name="localizedAttributes"> Any custom localized attributes for the Type. </param>
        /// <param name="smallImage"> Small Image associated with the Property or EntityType. </param>
        /// <param name="mediumImage"> Medium Image associated with the Property or EntityType. </param>
        /// <param name="largeImage"> Large Image associated with the Property or EntityType. </param>
        /// <param name="apiEntitySetName"> The api entity set name. This becomes the odata entity set name for the entity Type being referred in this object. </param>
        /// <param name="entityType"> Type of entity. </param>
        /// <param name="fields"> The properties of the Profile. </param>
        /// <param name="instancesCount"> The instance count. </param>
        /// <param name="lastChangedUtc"> The last changed time for the type definition. </param>
        /// <param name="provisioningState"> Provisioning state. </param>
        /// <param name="schemaItemTypeLink"> The schema org link. This helps ACI identify and suggest semantic models. </param>
        /// <param name="tenantId"> The hub name. </param>
        /// <param name="timestampFieldName"> The timestamp property name. Represents the time when the interaction or profile update happened. </param>
        /// <param name="typeName"> The name of the entity. </param>
        /// <param name="idPropertyNames"> The id property names. Properties which uniquely identify an interaction instance. </param>
        /// <param name="participantProfiles"> Profiles that participated in the interaction. </param>
        /// <param name="primaryParticipantProfilePropertyName"> The primary participant property name for an interaction ,This is used to logically represent the agent of the interaction, Specify the participant name here from ParticipantName. </param>
        /// <param name="dataSourcePrecedenceRules"> This is specific to interactions modeled as activities. Data sources are used to determine where data is stored and also in precedence rules. </param>
        /// <param name="isActivity"> An interaction can be tagged as an activity only during create. This enables the interaction to be editable and can enable merging of properties from multiple data sources based on precedence, which is defined at a link level. </param>
        /// <param name="namePropertiesDefaultDataSourceName"> The data source name. </param>
        /// <param name="dataSourceType"> The data source type. </param>
        /// <param name="status"> The data source status. </param>
        /// <param name="idPropertiesDefaultDataSourceId"> The data source ID. </param>
        /// <param name="dataSourceReferenceId"> The data source reference id. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal InteractionResourceFormatData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, IList<string>> attributes, IDictionary<string, string> description, IDictionary<string, string> displayName, IDictionary<string, IDictionary<string, string>> localizedAttributes, string smallImage, string mediumImage, string largeImage, string apiEntitySetName, EntityType? entityType, IList<PropertyDefinition> fields, int? instancesCount, DateTimeOffset? lastChangedUtc, ProvisioningState? provisioningState, string schemaItemTypeLink, Guid? tenantId, string timestampFieldName, string typeName, IList<string> idPropertyNames, IList<Participant> participantProfiles, string primaryParticipantProfilePropertyName, IReadOnlyList<DataSourcePrecedence> dataSourcePrecedenceRules, bool? isActivity, string namePropertiesDefaultDataSourceName, DataSourceType? dataSourceType, Status? status, int? idPropertiesDefaultDataSourceId, string dataSourceReferenceId, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            Attributes = attributes;
            Description = description;
            DisplayName = displayName;
            LocalizedAttributes = localizedAttributes;
            SmallImage = smallImage;
            MediumImage = mediumImage;
            LargeImage = largeImage;
            ApiEntitySetName = apiEntitySetName;
            EntityType = entityType;
            Fields = fields;
            InstancesCount = instancesCount;
            LastChangedUtc = lastChangedUtc;
            ProvisioningState = provisioningState;
            SchemaItemTypeLink = schemaItemTypeLink;
            TenantId = tenantId;
            TimestampFieldName = timestampFieldName;
            TypeName = typeName;
            IdPropertyNames = idPropertyNames;
            ParticipantProfiles = participantProfiles;
            PrimaryParticipantProfilePropertyName = primaryParticipantProfilePropertyName;
            DataSourcePrecedenceRules = dataSourcePrecedenceRules;
            IsActivity = isActivity;
            NamePropertiesDefaultDataSourceName = namePropertiesDefaultDataSourceName;
            DataSourceType = dataSourceType;
            Status = status;
            IdPropertiesDefaultDataSourceId = idPropertiesDefaultDataSourceId;
            DataSourceReferenceId = dataSourceReferenceId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The attributes for the Type. </summary>
        public IDictionary<string, IList<string>> Attributes { get; }
        /// <summary> Localized descriptions for the property. </summary>
        public IDictionary<string, string> Description { get; }
        /// <summary> Localized display names for the property. </summary>
        public IDictionary<string, string> DisplayName { get; }
        /// <summary> Any custom localized attributes for the Type. </summary>
        public IDictionary<string, IDictionary<string, string>> LocalizedAttributes { get; }
        /// <summary> Small Image associated with the Property or EntityType. </summary>
        public string SmallImage { get; set; }
        /// <summary> Medium Image associated with the Property or EntityType. </summary>
        public string MediumImage { get; set; }
        /// <summary> Large Image associated with the Property or EntityType. </summary>
        public string LargeImage { get; set; }
        /// <summary> The api entity set name. This becomes the odata entity set name for the entity Type being referred in this object. </summary>
        public string ApiEntitySetName { get; set; }
        /// <summary> Type of entity. </summary>
        public EntityType? EntityType { get; set; }
        /// <summary> The properties of the Profile. </summary>
        public IList<PropertyDefinition> Fields { get; }
        /// <summary> The instance count. </summary>
        public int? InstancesCount { get; set; }
        /// <summary> The last changed time for the type definition. </summary>
        public DateTimeOffset? LastChangedUtc { get; }
        /// <summary> Provisioning state. </summary>
        public ProvisioningState? ProvisioningState { get; }
        /// <summary> The schema org link. This helps ACI identify and suggest semantic models. </summary>
        public string SchemaItemTypeLink { get; set; }
        /// <summary> The hub name. </summary>
        public Guid? TenantId { get; }
        /// <summary> The timestamp property name. Represents the time when the interaction or profile update happened. </summary>
        public string TimestampFieldName { get; set; }
        /// <summary> The name of the entity. </summary>
        public string TypeName { get; set; }
        /// <summary> The id property names. Properties which uniquely identify an interaction instance. </summary>
        public IList<string> IdPropertyNames { get; }
        /// <summary> Profiles that participated in the interaction. </summary>
        public IList<Participant> ParticipantProfiles { get; }
        /// <summary> The primary participant property name for an interaction ,This is used to logically represent the agent of the interaction, Specify the participant name here from ParticipantName. </summary>
        public string PrimaryParticipantProfilePropertyName { get; set; }
        /// <summary> This is specific to interactions modeled as activities. Data sources are used to determine where data is stored and also in precedence rules. </summary>
        public IReadOnlyList<DataSourcePrecedence> DataSourcePrecedenceRules { get; }
        /// <summary> An interaction can be tagged as an activity only during create. This enables the interaction to be editable and can enable merging of properties from multiple data sources based on precedence, which is defined at a link level. </summary>
        public bool? IsActivity { get; set; }
        /// <summary> The data source name. </summary>
        public string NamePropertiesDefaultDataSourceName { get; }
        /// <summary> The data source type. </summary>
        public DataSourceType? DataSourceType { get; }
        /// <summary> The data source status. </summary>
        public Status? Status { get; }
        /// <summary> The data source ID. </summary>
        public int? IdPropertiesDefaultDataSourceId { get; }
        /// <summary> The data source reference id. </summary>
        public string DataSourceReferenceId { get; }
    }
}
