// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.CustomerInsights.Models;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.CustomerInsights
{
    /// <summary>
    /// A Class representing a Hub along with the instance operations that can be performed on it.
    /// If you have a <see cref="ResourceIdentifier"/> you can construct a <see cref="HubResource"/>
    /// from an instance of <see cref="ArmClient"/> using the GetHubResource method.
    /// Otherwise you can get one from its parent resource <see cref="ResourceGroupResource"/> using the GetHub method.
    /// </summary>
    public partial class HubResource : ArmResource
    {
        /// <summary> Generate the resource identifier of a <see cref="HubResource"/> instance. </summary>
        /// <param name="subscriptionId"> The subscriptionId. </param>
        /// <param name="resourceGroupName"> The resourceGroupName. </param>
        /// <param name="hubName"> The hubName. </param>
        public static ResourceIdentifier CreateResourceIdentifier(string subscriptionId, string resourceGroupName, string hubName)
        {
            var resourceId = $"/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}";
            return new ResourceIdentifier(resourceId);
        }

        private readonly ClientDiagnostics _hubClientDiagnostics;
        private readonly HubsRestOperations _hubRestClient;
        private readonly ClientDiagnostics _rolesClientDiagnostics;
        private readonly RolesRestOperations _rolesRestClient;
        private readonly ClientDiagnostics _imagesClientDiagnostics;
        private readonly ImagesRestOperations _imagesRestClient;
        private readonly HubData _data;

        /// <summary> Gets the resource type for the operations. </summary>
        public static readonly ResourceType ResourceType = "Microsoft.CustomerInsights/hubs";

        /// <summary> Initializes a new instance of the <see cref="HubResource"/> class for mocking. </summary>
        protected HubResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="HubResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="data"> The resource that is the target of operations. </param>
        internal HubResource(ArmClient client, HubData data) : this(client, data.Id)
        {
            HasData = true;
            _data = data;
        }

        /// <summary> Initializes a new instance of the <see cref="HubResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal HubResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _hubClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.CustomerInsights", ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ResourceType, out string hubApiVersion);
            _hubRestClient = new HubsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, hubApiVersion);
            _rolesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.CustomerInsights", ProviderConstants.DefaultProviderNamespace, Diagnostics);
            _rolesRestClient = new RolesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint);
            _imagesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.CustomerInsights", ProviderConstants.DefaultProviderNamespace, Diagnostics);
            _imagesRestClient = new ImagesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        /// <summary> Gets whether or not the current instance has data. </summary>
        public virtual bool HasData { get; }

        /// <summary> Gets the data representing this Feature. </summary>
        /// <exception cref="InvalidOperationException"> Throws if there is no data loaded in the current instance. </exception>
        public virtual HubData Data
        {
            get
            {
                if (!HasData)
                    throw new InvalidOperationException("The current instance does not have data, you must call Get first.");
                return _data;
            }
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceType), nameof(id));
        }

        /// <summary> Gets a collection of ProfileResourceFormatResources in the Hub. </summary>
        /// <returns> An object representing collection of ProfileResourceFormatResources and their operations over a ProfileResourceFormatResource. </returns>
        public virtual ProfileResourceFormatCollection GetProfileResourceFormats()
        {
            return GetCachedClient(client => new ProfileResourceFormatCollection(client, Id));
        }

        /// <summary>
        /// Gets information about the specified profile.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/profiles/{profileName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Profiles_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ProfileResourceFormatResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="profileName"> The name of the profile. </param>
        /// <param name="localeCode"> Locale of profile to retrieve, default is en-us. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="profileName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="profileName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<ProfileResourceFormatResource>> GetProfileResourceFormatAsync(string profileName, string localeCode = null, CancellationToken cancellationToken = default)
        {
            return await GetProfileResourceFormats().GetAsync(profileName, localeCode, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Gets information about the specified profile.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/profiles/{profileName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Profiles_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ProfileResourceFormatResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="profileName"> The name of the profile. </param>
        /// <param name="localeCode"> Locale of profile to retrieve, default is en-us. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="profileName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="profileName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<ProfileResourceFormatResource> GetProfileResourceFormat(string profileName, string localeCode = null, CancellationToken cancellationToken = default)
        {
            return GetProfileResourceFormats().Get(profileName, localeCode, cancellationToken);
        }

        /// <summary> Gets a collection of InteractionResourceFormatResources in the Hub. </summary>
        /// <returns> An object representing collection of InteractionResourceFormatResources and their operations over a InteractionResourceFormatResource. </returns>
        public virtual InteractionResourceFormatCollection GetInteractionResourceFormats()
        {
            return GetCachedClient(client => new InteractionResourceFormatCollection(client, Id));
        }

        /// <summary>
        /// Gets information about the specified interaction.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/interactions/{interactionName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Interactions_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="InteractionResourceFormatResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="interactionName"> The name of the interaction. </param>
        /// <param name="localeCode"> Locale of interaction to retrieve, default is en-us. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="interactionName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="interactionName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<InteractionResourceFormatResource>> GetInteractionResourceFormatAsync(string interactionName, string localeCode = null, CancellationToken cancellationToken = default)
        {
            return await GetInteractionResourceFormats().GetAsync(interactionName, localeCode, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Gets information about the specified interaction.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/interactions/{interactionName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Interactions_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="InteractionResourceFormatResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="interactionName"> The name of the interaction. </param>
        /// <param name="localeCode"> Locale of interaction to retrieve, default is en-us. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="interactionName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="interactionName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<InteractionResourceFormatResource> GetInteractionResourceFormat(string interactionName, string localeCode = null, CancellationToken cancellationToken = default)
        {
            return GetInteractionResourceFormats().Get(interactionName, localeCode, cancellationToken);
        }

        /// <summary> Gets a collection of RelationshipResourceFormatResources in the Hub. </summary>
        /// <returns> An object representing collection of RelationshipResourceFormatResources and their operations over a RelationshipResourceFormatResource. </returns>
        public virtual RelationshipResourceFormatCollection GetRelationshipResourceFormats()
        {
            return GetCachedClient(client => new RelationshipResourceFormatCollection(client, Id));
        }

        /// <summary>
        /// Gets information about the specified relationship.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/relationships/{relationshipName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Relationships_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="RelationshipResourceFormatResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="relationshipName"> The name of the relationship. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="relationshipName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="relationshipName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<RelationshipResourceFormatResource>> GetRelationshipResourceFormatAsync(string relationshipName, CancellationToken cancellationToken = default)
        {
            return await GetRelationshipResourceFormats().GetAsync(relationshipName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Gets information about the specified relationship.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/relationships/{relationshipName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Relationships_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="RelationshipResourceFormatResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="relationshipName"> The name of the relationship. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="relationshipName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="relationshipName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<RelationshipResourceFormatResource> GetRelationshipResourceFormat(string relationshipName, CancellationToken cancellationToken = default)
        {
            return GetRelationshipResourceFormats().Get(relationshipName, cancellationToken);
        }

        /// <summary> Gets a collection of RelationshipLinkResourceFormatResources in the Hub. </summary>
        /// <returns> An object representing collection of RelationshipLinkResourceFormatResources and their operations over a RelationshipLinkResourceFormatResource. </returns>
        public virtual RelationshipLinkResourceFormatCollection GetRelationshipLinkResourceFormats()
        {
            return GetCachedClient(client => new RelationshipLinkResourceFormatCollection(client, Id));
        }

        /// <summary>
        /// Gets information about the specified relationship Link.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/relationshipLinks/{relationshipLinkName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>RelationshipLinks_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="RelationshipLinkResourceFormatResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="relationshipLinkName"> The name of the relationship link. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="relationshipLinkName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="relationshipLinkName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<RelationshipLinkResourceFormatResource>> GetRelationshipLinkResourceFormatAsync(string relationshipLinkName, CancellationToken cancellationToken = default)
        {
            return await GetRelationshipLinkResourceFormats().GetAsync(relationshipLinkName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Gets information about the specified relationship Link.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/relationshipLinks/{relationshipLinkName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>RelationshipLinks_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="RelationshipLinkResourceFormatResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="relationshipLinkName"> The name of the relationship link. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="relationshipLinkName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="relationshipLinkName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<RelationshipLinkResourceFormatResource> GetRelationshipLinkResourceFormat(string relationshipLinkName, CancellationToken cancellationToken = default)
        {
            return GetRelationshipLinkResourceFormats().Get(relationshipLinkName, cancellationToken);
        }

        /// <summary> Gets a collection of AuthorizationPolicyResourceFormatResources in the Hub. </summary>
        /// <returns> An object representing collection of AuthorizationPolicyResourceFormatResources and their operations over a AuthorizationPolicyResourceFormatResource. </returns>
        public virtual AuthorizationPolicyResourceFormatCollection GetAuthorizationPolicyResourceFormats()
        {
            return GetCachedClient(client => new AuthorizationPolicyResourceFormatCollection(client, Id));
        }

        /// <summary>
        /// Gets an authorization policy in the hub.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/authorizationPolicies/{authorizationPolicyName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AuthorizationPolicies_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AuthorizationPolicyResourceFormatResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="authorizationPolicyName"> The name of the policy. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="authorizationPolicyName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="authorizationPolicyName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<AuthorizationPolicyResourceFormatResource>> GetAuthorizationPolicyResourceFormatAsync(string authorizationPolicyName, CancellationToken cancellationToken = default)
        {
            return await GetAuthorizationPolicyResourceFormats().GetAsync(authorizationPolicyName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Gets an authorization policy in the hub.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/authorizationPolicies/{authorizationPolicyName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AuthorizationPolicies_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AuthorizationPolicyResourceFormatResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="authorizationPolicyName"> The name of the policy. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="authorizationPolicyName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="authorizationPolicyName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<AuthorizationPolicyResourceFormatResource> GetAuthorizationPolicyResourceFormat(string authorizationPolicyName, CancellationToken cancellationToken = default)
        {
            return GetAuthorizationPolicyResourceFormats().Get(authorizationPolicyName, cancellationToken);
        }

        /// <summary> Gets a collection of ConnectorResourceFormatResources in the Hub. </summary>
        /// <returns> An object representing collection of ConnectorResourceFormatResources and their operations over a ConnectorResourceFormatResource. </returns>
        public virtual ConnectorResourceFormatCollection GetConnectorResourceFormats()
        {
            return GetCachedClient(client => new ConnectorResourceFormatCollection(client, Id));
        }

        /// <summary>
        /// Gets a connector in the hub.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/connectors/{connectorName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Connectors_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectorResourceFormatResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="connectorName"> The name of the connector. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="connectorName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="connectorName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<ConnectorResourceFormatResource>> GetConnectorResourceFormatAsync(string connectorName, CancellationToken cancellationToken = default)
        {
            return await GetConnectorResourceFormats().GetAsync(connectorName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Gets a connector in the hub.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/connectors/{connectorName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Connectors_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectorResourceFormatResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="connectorName"> The name of the connector. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="connectorName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="connectorName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<ConnectorResourceFormatResource> GetConnectorResourceFormat(string connectorName, CancellationToken cancellationToken = default)
        {
            return GetConnectorResourceFormats().Get(connectorName, cancellationToken);
        }

        /// <summary> Gets a collection of KpiResourceFormatResources in the Hub. </summary>
        /// <returns> An object representing collection of KpiResourceFormatResources and their operations over a KpiResourceFormatResource. </returns>
        public virtual KpiResourceFormatCollection GetKpiResourceFormats()
        {
            return GetCachedClient(client => new KpiResourceFormatCollection(client, Id));
        }

        /// <summary>
        /// Gets a KPI in the hub.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/kpi/{kpiName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Kpi_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="KpiResourceFormatResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="kpiName"> The name of the KPI. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="kpiName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="kpiName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<KpiResourceFormatResource>> GetKpiResourceFormatAsync(string kpiName, CancellationToken cancellationToken = default)
        {
            return await GetKpiResourceFormats().GetAsync(kpiName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Gets a KPI in the hub.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/kpi/{kpiName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Kpi_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="KpiResourceFormatResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="kpiName"> The name of the KPI. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="kpiName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="kpiName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<KpiResourceFormatResource> GetKpiResourceFormat(string kpiName, CancellationToken cancellationToken = default)
        {
            return GetKpiResourceFormats().Get(kpiName, cancellationToken);
        }

        /// <summary> Gets a collection of WidgetTypeResourceFormatResources in the Hub. </summary>
        /// <returns> An object representing collection of WidgetTypeResourceFormatResources and their operations over a WidgetTypeResourceFormatResource. </returns>
        public virtual WidgetTypeResourceFormatCollection GetWidgetTypeResourceFormats()
        {
            return GetCachedClient(client => new WidgetTypeResourceFormatCollection(client, Id));
        }

        /// <summary>
        /// Gets a widget type in the specified hub.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/widgetTypes/{widgetTypeName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WidgetTypes_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="WidgetTypeResourceFormatResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="widgetTypeName"> The name of the widget type. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="widgetTypeName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="widgetTypeName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<WidgetTypeResourceFormatResource>> GetWidgetTypeResourceFormatAsync(string widgetTypeName, CancellationToken cancellationToken = default)
        {
            return await GetWidgetTypeResourceFormats().GetAsync(widgetTypeName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Gets a widget type in the specified hub.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/widgetTypes/{widgetTypeName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WidgetTypes_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="WidgetTypeResourceFormatResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="widgetTypeName"> The name of the widget type. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="widgetTypeName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="widgetTypeName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<WidgetTypeResourceFormatResource> GetWidgetTypeResourceFormat(string widgetTypeName, CancellationToken cancellationToken = default)
        {
            return GetWidgetTypeResourceFormats().Get(widgetTypeName, cancellationToken);
        }

        /// <summary> Gets a collection of ViewResourceFormatResources in the Hub. </summary>
        /// <returns> An object representing collection of ViewResourceFormatResources and their operations over a ViewResourceFormatResource. </returns>
        public virtual ViewResourceFormatCollection GetViewResourceFormats()
        {
            return GetCachedClient(client => new ViewResourceFormatCollection(client, Id));
        }

        /// <summary>
        /// Gets a view in the hub.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/views/{viewName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Views_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ViewResourceFormatResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="viewName"> The name of the view. </param>
        /// <param name="userId"> The user ID. Use * to retrieve hub level view. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="viewName"/> or <paramref name="userId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="viewName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<ViewResourceFormatResource>> GetViewResourceFormatAsync(string viewName, string userId, CancellationToken cancellationToken = default)
        {
            return await GetViewResourceFormats().GetAsync(viewName, userId, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Gets a view in the hub.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/views/{viewName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Views_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ViewResourceFormatResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="viewName"> The name of the view. </param>
        /// <param name="userId"> The user ID. Use * to retrieve hub level view. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="viewName"/> or <paramref name="userId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="viewName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<ViewResourceFormatResource> GetViewResourceFormat(string viewName, string userId, CancellationToken cancellationToken = default)
        {
            return GetViewResourceFormats().Get(viewName, userId, cancellationToken);
        }

        /// <summary> Gets a collection of LinkResourceFormatResources in the Hub. </summary>
        /// <returns> An object representing collection of LinkResourceFormatResources and their operations over a LinkResourceFormatResource. </returns>
        public virtual LinkResourceFormatCollection GetLinkResourceFormats()
        {
            return GetCachedClient(client => new LinkResourceFormatCollection(client, Id));
        }

        /// <summary>
        /// Gets a link in the hub.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/links/{linkName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Links_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="LinkResourceFormatResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="linkName"> The name of the link. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="linkName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="linkName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<LinkResourceFormatResource>> GetLinkResourceFormatAsync(string linkName, CancellationToken cancellationToken = default)
        {
            return await GetLinkResourceFormats().GetAsync(linkName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Gets a link in the hub.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/links/{linkName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Links_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="LinkResourceFormatResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="linkName"> The name of the link. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="linkName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="linkName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<LinkResourceFormatResource> GetLinkResourceFormat(string linkName, CancellationToken cancellationToken = default)
        {
            return GetLinkResourceFormats().Get(linkName, cancellationToken);
        }

        /// <summary> Gets a collection of RoleAssignmentResourceFormatResources in the Hub. </summary>
        /// <returns> An object representing collection of RoleAssignmentResourceFormatResources and their operations over a RoleAssignmentResourceFormatResource. </returns>
        public virtual RoleAssignmentResourceFormatCollection GetRoleAssignmentResourceFormats()
        {
            return GetCachedClient(client => new RoleAssignmentResourceFormatCollection(client, Id));
        }

        /// <summary>
        /// Gets the role assignment in the hub.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/roleAssignments/{assignmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>RoleAssignments_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="RoleAssignmentResourceFormatResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="assignmentName"> The name of the role assignment. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="assignmentName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="assignmentName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<RoleAssignmentResourceFormatResource>> GetRoleAssignmentResourceFormatAsync(string assignmentName, CancellationToken cancellationToken = default)
        {
            return await GetRoleAssignmentResourceFormats().GetAsync(assignmentName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Gets the role assignment in the hub.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/roleAssignments/{assignmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>RoleAssignments_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="RoleAssignmentResourceFormatResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="assignmentName"> The name of the role assignment. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="assignmentName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="assignmentName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<RoleAssignmentResourceFormatResource> GetRoleAssignmentResourceFormat(string assignmentName, CancellationToken cancellationToken = default)
        {
            return GetRoleAssignmentResourceFormats().Get(assignmentName, cancellationToken);
        }

        /// <summary> Gets a collection of PredictionResourceFormatResources in the Hub. </summary>
        /// <returns> An object representing collection of PredictionResourceFormatResources and their operations over a PredictionResourceFormatResource. </returns>
        public virtual PredictionResourceFormatCollection GetPredictionResourceFormats()
        {
            return GetCachedClient(client => new PredictionResourceFormatCollection(client, Id));
        }

        /// <summary>
        /// Gets a Prediction in the hub.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/predictions/{predictionName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Predictions_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="PredictionResourceFormatResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="predictionName"> The name of the Prediction. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="predictionName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="predictionName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<PredictionResourceFormatResource>> GetPredictionResourceFormatAsync(string predictionName, CancellationToken cancellationToken = default)
        {
            return await GetPredictionResourceFormats().GetAsync(predictionName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Gets a Prediction in the hub.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/predictions/{predictionName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Predictions_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="PredictionResourceFormatResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="predictionName"> The name of the Prediction. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="predictionName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="predictionName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<PredictionResourceFormatResource> GetPredictionResourceFormat(string predictionName, CancellationToken cancellationToken = default)
        {
            return GetPredictionResourceFormats().Get(predictionName, cancellationToken);
        }

        /// <summary>
        /// Gets information about the specified hub.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Hubs_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="HubResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<HubResource>> GetAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _hubClientDiagnostics.CreateScope("HubResource.Get");
            scope.Start();
            try
            {
                var response = await _hubRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new HubResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets information about the specified hub.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Hubs_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="HubResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<HubResource> Get(CancellationToken cancellationToken = default)
        {
            using var scope = _hubClientDiagnostics.CreateScope("HubResource.Get");
            scope.Start();
            try
            {
                var response = _hubRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new HubResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Deletes the specified hub.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Hubs_Delete</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="HubResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<ArmOperation> DeleteAsync(WaitUntil waitUntil, CancellationToken cancellationToken = default)
        {
            using var scope = _hubClientDiagnostics.CreateScope("HubResource.Delete");
            scope.Start();
            try
            {
                var response = await _hubRestClient.DeleteAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, cancellationToken).ConfigureAwait(false);
                var operation = new CustomerInsightsArmOperation(_hubClientDiagnostics, Pipeline, _hubRestClient.CreateDeleteRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionResponseAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Deletes the specified hub.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Hubs_Delete</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="HubResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual ArmOperation Delete(WaitUntil waitUntil, CancellationToken cancellationToken = default)
        {
            using var scope = _hubClientDiagnostics.CreateScope("HubResource.Delete");
            scope.Start();
            try
            {
                var response = _hubRestClient.Delete(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, cancellationToken);
                var operation = new CustomerInsightsArmOperation(_hubClientDiagnostics, Pipeline, _hubRestClient.CreateDeleteRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletionResponse(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Updates a Hub.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Hubs_Update</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="HubResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="data"> Parameters supplied to the Update Hub operation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="data"/> is null. </exception>
        public virtual async Task<Response<HubResource>> UpdateAsync(HubData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _hubClientDiagnostics.CreateScope("HubResource.Update");
            scope.Start();
            try
            {
                var response = await _hubRestClient.UpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, data, cancellationToken).ConfigureAwait(false);
                return Response.FromValue(new HubResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Updates a Hub.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Hubs_Update</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="HubResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="data"> Parameters supplied to the Update Hub operation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="data"/> is null. </exception>
        public virtual Response<HubResource> Update(HubData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _hubClientDiagnostics.CreateScope("HubResource.Update");
            scope.Start();
            try
            {
                var response = _hubRestClient.Update(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, data, cancellationToken);
                return Response.FromValue(new HubResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets all the roles for the hub.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/roles</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Roles_ListByHub</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="RoleResourceFormat"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<RoleResourceFormat> GetRolesAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _rolesRestClient.CreateListByHubRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _rolesRestClient.CreateListByHubNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => RoleResourceFormat.DeserializeRoleResourceFormat(e), _rolesClientDiagnostics, Pipeline, "HubResource.GetRoles", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Gets all the roles for the hub.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/roles</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Roles_ListByHub</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="RoleResourceFormat"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<RoleResourceFormat> GetRoles(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _rolesRestClient.CreateListByHubRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _rolesRestClient.CreateListByHubNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => RoleResourceFormat.DeserializeRoleResourceFormat(e), _rolesClientDiagnostics, Pipeline, "HubResource.GetRoles", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Gets entity type (profile or interaction) image upload URL.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/images/getEntityTypeImageUploadUrl</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Images_GetUploadUrlForEntityType</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="input"> Parameters supplied to the GetUploadUrlForEntityType operation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="input"/> is null. </exception>
        public virtual async Task<Response<ImageDefinition>> GetUploadUrlForEntityTypeImageAsync(GetImageUploadUrlInput input, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(input, nameof(input));

            using var scope = _imagesClientDiagnostics.CreateScope("HubResource.GetUploadUrlForEntityTypeImage");
            scope.Start();
            try
            {
                var response = await _imagesRestClient.GetUploadUrlForEntityTypeAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, input, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets entity type (profile or interaction) image upload URL.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/images/getEntityTypeImageUploadUrl</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Images_GetUploadUrlForEntityType</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="input"> Parameters supplied to the GetUploadUrlForEntityType operation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="input"/> is null. </exception>
        public virtual Response<ImageDefinition> GetUploadUrlForEntityTypeImage(GetImageUploadUrlInput input, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(input, nameof(input));

            using var scope = _imagesClientDiagnostics.CreateScope("HubResource.GetUploadUrlForEntityTypeImage");
            scope.Start();
            try
            {
                var response = _imagesRestClient.GetUploadUrlForEntityType(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, input, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets data image upload URL.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/images/getDataImageUploadUrl</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Images_GetUploadUrlForData</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="input"> Parameters supplied to the GetUploadUrlForData operation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="input"/> is null. </exception>
        public virtual async Task<Response<ImageDefinition>> GetUploadUrlForDataImageAsync(GetImageUploadUrlInput input, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(input, nameof(input));

            using var scope = _imagesClientDiagnostics.CreateScope("HubResource.GetUploadUrlForDataImage");
            scope.Start();
            try
            {
                var response = await _imagesRestClient.GetUploadUrlForDataAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, input, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets data image upload URL.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/images/getDataImageUploadUrl</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Images_GetUploadUrlForData</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="input"> Parameters supplied to the GetUploadUrlForData operation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="input"/> is null. </exception>
        public virtual Response<ImageDefinition> GetUploadUrlForDataImage(GetImageUploadUrlInput input, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(input, nameof(input));

            using var scope = _imagesClientDiagnostics.CreateScope("HubResource.GetUploadUrlForDataImage");
            scope.Start();
            try
            {
                var response = _imagesRestClient.GetUploadUrlForData(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, input, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Add a tag to the current resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Hubs_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="HubResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="key"> The key for the tag. </param>
        /// <param name="value"> The value for the tag. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="key"/> or <paramref name="value"/> is null. </exception>
        public virtual async Task<Response<HubResource>> AddTagAsync(string key, string value, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(key, nameof(key));
            Argument.AssertNotNull(value, nameof(value));

            using var scope = _hubClientDiagnostics.CreateScope("HubResource.AddTag");
            scope.Start();
            try
            {
                if (await CanUseTagResourceAsync(cancellationToken: cancellationToken).ConfigureAwait(false))
                {
                    var originalTags = await GetTagResource().GetAsync(cancellationToken).ConfigureAwait(false);
                    originalTags.Value.Data.TagValues[key] = value;
                    await GetTagResource().CreateOrUpdateAsync(WaitUntil.Completed, originalTags.Value.Data, cancellationToken: cancellationToken).ConfigureAwait(false);
                    var originalResponse = await _hubRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, cancellationToken).ConfigureAwait(false);
                    return Response.FromValue(new HubResource(Client, originalResponse.Value), originalResponse.GetRawResponse());
                }
                else
                {
                    var current = (await GetAsync(cancellationToken: cancellationToken).ConfigureAwait(false)).Value.Data;
                    var patch = new HubData(current.Location);
                    foreach (var tag in current.Tags)
                    {
                        patch.Tags.Add(tag);
                    }
                    patch.Tags[key] = value;
                    var result = await UpdateAsync(patch, cancellationToken: cancellationToken).ConfigureAwait(false);
                    return result;
                }
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Add a tag to the current resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Hubs_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="HubResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="key"> The key for the tag. </param>
        /// <param name="value"> The value for the tag. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="key"/> or <paramref name="value"/> is null. </exception>
        public virtual Response<HubResource> AddTag(string key, string value, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(key, nameof(key));
            Argument.AssertNotNull(value, nameof(value));

            using var scope = _hubClientDiagnostics.CreateScope("HubResource.AddTag");
            scope.Start();
            try
            {
                if (CanUseTagResource(cancellationToken: cancellationToken))
                {
                    var originalTags = GetTagResource().Get(cancellationToken);
                    originalTags.Value.Data.TagValues[key] = value;
                    GetTagResource().CreateOrUpdate(WaitUntil.Completed, originalTags.Value.Data, cancellationToken: cancellationToken);
                    var originalResponse = _hubRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, cancellationToken);
                    return Response.FromValue(new HubResource(Client, originalResponse.Value), originalResponse.GetRawResponse());
                }
                else
                {
                    var current = Get(cancellationToken: cancellationToken).Value.Data;
                    var patch = new HubData(current.Location);
                    foreach (var tag in current.Tags)
                    {
                        patch.Tags.Add(tag);
                    }
                    patch.Tags[key] = value;
                    var result = Update(patch, cancellationToken: cancellationToken);
                    return result;
                }
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Replace the tags on the resource with the given set.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Hubs_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="HubResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="tags"> The set of tags to use as replacement. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="tags"/> is null. </exception>
        public virtual async Task<Response<HubResource>> SetTagsAsync(IDictionary<string, string> tags, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(tags, nameof(tags));

            using var scope = _hubClientDiagnostics.CreateScope("HubResource.SetTags");
            scope.Start();
            try
            {
                if (await CanUseTagResourceAsync(cancellationToken: cancellationToken).ConfigureAwait(false))
                {
                    await GetTagResource().DeleteAsync(WaitUntil.Completed, cancellationToken: cancellationToken).ConfigureAwait(false);
                    var originalTags = await GetTagResource().GetAsync(cancellationToken).ConfigureAwait(false);
                    originalTags.Value.Data.TagValues.ReplaceWith(tags);
                    await GetTagResource().CreateOrUpdateAsync(WaitUntil.Completed, originalTags.Value.Data, cancellationToken: cancellationToken).ConfigureAwait(false);
                    var originalResponse = await _hubRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, cancellationToken).ConfigureAwait(false);
                    return Response.FromValue(new HubResource(Client, originalResponse.Value), originalResponse.GetRawResponse());
                }
                else
                {
                    var current = (await GetAsync(cancellationToken: cancellationToken).ConfigureAwait(false)).Value.Data;
                    var patch = new HubData(current.Location);
                    patch.Tags.ReplaceWith(tags);
                    var result = await UpdateAsync(patch, cancellationToken: cancellationToken).ConfigureAwait(false);
                    return result;
                }
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Replace the tags on the resource with the given set.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Hubs_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="HubResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="tags"> The set of tags to use as replacement. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="tags"/> is null. </exception>
        public virtual Response<HubResource> SetTags(IDictionary<string, string> tags, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(tags, nameof(tags));

            using var scope = _hubClientDiagnostics.CreateScope("HubResource.SetTags");
            scope.Start();
            try
            {
                if (CanUseTagResource(cancellationToken: cancellationToken))
                {
                    GetTagResource().Delete(WaitUntil.Completed, cancellationToken: cancellationToken);
                    var originalTags = GetTagResource().Get(cancellationToken);
                    originalTags.Value.Data.TagValues.ReplaceWith(tags);
                    GetTagResource().CreateOrUpdate(WaitUntil.Completed, originalTags.Value.Data, cancellationToken: cancellationToken);
                    var originalResponse = _hubRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, cancellationToken);
                    return Response.FromValue(new HubResource(Client, originalResponse.Value), originalResponse.GetRawResponse());
                }
                else
                {
                    var current = Get(cancellationToken: cancellationToken).Value.Data;
                    var patch = new HubData(current.Location);
                    patch.Tags.ReplaceWith(tags);
                    var result = Update(patch, cancellationToken: cancellationToken);
                    return result;
                }
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Removes a tag by key from the resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Hubs_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="HubResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="key"> The key for the tag. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="key"/> is null. </exception>
        public virtual async Task<Response<HubResource>> RemoveTagAsync(string key, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(key, nameof(key));

            using var scope = _hubClientDiagnostics.CreateScope("HubResource.RemoveTag");
            scope.Start();
            try
            {
                if (await CanUseTagResourceAsync(cancellationToken: cancellationToken).ConfigureAwait(false))
                {
                    var originalTags = await GetTagResource().GetAsync(cancellationToken).ConfigureAwait(false);
                    originalTags.Value.Data.TagValues.Remove(key);
                    await GetTagResource().CreateOrUpdateAsync(WaitUntil.Completed, originalTags.Value.Data, cancellationToken: cancellationToken).ConfigureAwait(false);
                    var originalResponse = await _hubRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, cancellationToken).ConfigureAwait(false);
                    return Response.FromValue(new HubResource(Client, originalResponse.Value), originalResponse.GetRawResponse());
                }
                else
                {
                    var current = (await GetAsync(cancellationToken: cancellationToken).ConfigureAwait(false)).Value.Data;
                    var patch = new HubData(current.Location);
                    foreach (var tag in current.Tags)
                    {
                        patch.Tags.Add(tag);
                    }
                    patch.Tags.Remove(key);
                    var result = await UpdateAsync(patch, cancellationToken: cancellationToken).ConfigureAwait(false);
                    return result;
                }
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Removes a tag by key from the resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Hubs_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="HubResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="key"> The key for the tag. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="key"/> is null. </exception>
        public virtual Response<HubResource> RemoveTag(string key, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(key, nameof(key));

            using var scope = _hubClientDiagnostics.CreateScope("HubResource.RemoveTag");
            scope.Start();
            try
            {
                if (CanUseTagResource(cancellationToken: cancellationToken))
                {
                    var originalTags = GetTagResource().Get(cancellationToken);
                    originalTags.Value.Data.TagValues.Remove(key);
                    GetTagResource().CreateOrUpdate(WaitUntil.Completed, originalTags.Value.Data, cancellationToken: cancellationToken);
                    var originalResponse = _hubRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, cancellationToken);
                    return Response.FromValue(new HubResource(Client, originalResponse.Value), originalResponse.GetRawResponse());
                }
                else
                {
                    var current = Get(cancellationToken: cancellationToken).Value.Data;
                    var patch = new HubData(current.Location);
                    foreach (var tag in current.Tags)
                    {
                        patch.Tags.Add(tag);
                    }
                    patch.Tags.Remove(key);
                    var result = Update(patch, cancellationToken: cancellationToken);
                    return result;
                }
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
