// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Threading;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.CustomerInsights.Mocking
{
    /// <summary> A class to add extension methods to SubscriptionResource. </summary>
    public partial class MockableCustomerInsightsSubscriptionResource : ArmResource
    {
        private ClientDiagnostics _hubClientDiagnostics;
        private HubsRestOperations _hubRestClient;

        /// <summary> Initializes a new instance of the <see cref="MockableCustomerInsightsSubscriptionResource"/> class for mocking. </summary>
        protected MockableCustomerInsightsSubscriptionResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableCustomerInsightsSubscriptionResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableCustomerInsightsSubscriptionResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        private ClientDiagnostics HubClientDiagnostics => _hubClientDiagnostics ??= new ClientDiagnostics("Azure.ResourceManager.CustomerInsights", HubResource.ResourceType.Namespace, Diagnostics);
        private HubsRestOperations HubRestClient => _hubRestClient ??= new HubsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, GetApiVersionOrNull(HubResource.ResourceType));

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets all hubs in the specified subscription.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.CustomerInsights/hubs</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Hubs_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="HubResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="HubResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<HubResource> GetHubsAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => HubRestClient.CreateListRequest(Id.SubscriptionId);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => HubRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new HubResource(Client, HubData.DeserializeHubData(e)), HubClientDiagnostics, Pipeline, "MockableCustomerInsightsSubscriptionResource.GetHubs", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Gets all hubs in the specified subscription.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.CustomerInsights/hubs</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Hubs_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="HubResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="HubResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<HubResource> GetHubs(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => HubRestClient.CreateListRequest(Id.SubscriptionId);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => HubRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new HubResource(Client, HubData.DeserializeHubData(e)), HubClientDiagnostics, Pipeline, "MockableCustomerInsightsSubscriptionResource.GetHubs", "value", "nextLink", cancellationToken);
        }
    }
}
