// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.CustomerInsights.Mocking
{
    /// <summary> A class to add extension methods to ResourceGroupResource. </summary>
    public partial class MockableCustomerInsightsResourceGroupResource : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableCustomerInsightsResourceGroupResource"/> class for mocking. </summary>
        protected MockableCustomerInsightsResourceGroupResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableCustomerInsightsResourceGroupResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableCustomerInsightsResourceGroupResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary> Gets a collection of HubResources in the ResourceGroupResource. </summary>
        /// <returns> An object representing collection of HubResources and their operations over a HubResource. </returns>
        public virtual HubCollection GetHubs()
        {
            return GetCachedClient(client => new HubCollection(client, Id));
        }

        /// <summary>
        /// Gets information about the specified hub.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Hubs_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="HubResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="hubName"> The name of the hub. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="hubName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="hubName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<HubResource>> GetHubAsync(string hubName, CancellationToken cancellationToken = default)
        {
            return await GetHubs().GetAsync(hubName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Gets information about the specified hub.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Hubs_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="HubResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="hubName"> The name of the hub. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="hubName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="hubName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<HubResource> GetHub(string hubName, CancellationToken cancellationToken = default)
        {
            return GetHubs().Get(hubName, cancellationToken);
        }
    }
}
