// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.CustomerInsights.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.CustomerInsights
{
    /// <summary>
    /// A class representing the ConnectorMappingResourceFormat data model.
    /// The connector mapping resource format.
    /// </summary>
    public partial class ConnectorMappingResourceFormatData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ConnectorMappingResourceFormatData"/>. </summary>
        public ConnectorMappingResourceFormatData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ConnectorMappingResourceFormatData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="connectorName"> The connector name. </param>
        /// <param name="connectorType"> Type of connector. </param>
        /// <param name="created"> The created time. </param>
        /// <param name="lastModified"> The last modified time. </param>
        /// <param name="entityType"> Defines which entity type the file should map to. </param>
        /// <param name="entityTypeName"> The mapping entity name. </param>
        /// <param name="connectorMappingName"> The connector mapping name. </param>
        /// <param name="displayName"> Display name for the connector mapping. </param>
        /// <param name="description"> The description of the connector mapping. </param>
        /// <param name="dataFormatId"> The DataFormat ID. </param>
        /// <param name="mappingProperties"> The properties of the mapping. </param>
        /// <param name="nextRunOn"> The next run time based on customer's settings. </param>
        /// <param name="runId"> The RunId. </param>
        /// <param name="state"> State of connector mapping. </param>
        /// <param name="tenantId"> The hub name. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ConnectorMappingResourceFormatData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string connectorName, ConnectorType? connectorType, DateTimeOffset? created, DateTimeOffset? lastModified, EntityType? entityType, string entityTypeName, string connectorMappingName, string displayName, string description, string dataFormatId, ConnectorMappingProperties mappingProperties, DateTimeOffset? nextRunOn, string runId, ConnectorMappingState? state, Guid? tenantId, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            ConnectorName = connectorName;
            ConnectorType = connectorType;
            Created = created;
            LastModified = lastModified;
            EntityType = entityType;
            EntityTypeName = entityTypeName;
            ConnectorMappingName = connectorMappingName;
            DisplayName = displayName;
            Description = description;
            DataFormatId = dataFormatId;
            MappingProperties = mappingProperties;
            NextRunOn = nextRunOn;
            RunId = runId;
            State = state;
            TenantId = tenantId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The connector name. </summary>
        public string ConnectorName { get; }
        /// <summary> Type of connector. </summary>
        public ConnectorType? ConnectorType { get; set; }
        /// <summary> The created time. </summary>
        public DateTimeOffset? Created { get; }
        /// <summary> The last modified time. </summary>
        public DateTimeOffset? LastModified { get; }
        /// <summary> Defines which entity type the file should map to. </summary>
        public EntityType? EntityType { get; set; }
        /// <summary> The mapping entity name. </summary>
        public string EntityTypeName { get; set; }
        /// <summary> The connector mapping name. </summary>
        public string ConnectorMappingName { get; }
        /// <summary> Display name for the connector mapping. </summary>
        public string DisplayName { get; set; }
        /// <summary> The description of the connector mapping. </summary>
        public string Description { get; set; }
        /// <summary> The DataFormat ID. </summary>
        public string DataFormatId { get; }
        /// <summary> The properties of the mapping. </summary>
        public ConnectorMappingProperties MappingProperties { get; set; }
        /// <summary> The next run time based on customer's settings. </summary>
        public DateTimeOffset? NextRunOn { get; }
        /// <summary> The RunId. </summary>
        public string RunId { get; }
        /// <summary> State of connector mapping. </summary>
        public ConnectorMappingState? State { get; }
        /// <summary> The hub name. </summary>
        public Guid? TenantId { get; }
    }
}
