// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.CustomerInsights.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.CustomerInsights
{
    /// <summary>
    /// A class representing the AuthorizationPolicyResourceFormat data model.
    /// The authorization policy resource format.
    /// </summary>
    public partial class AuthorizationPolicyResourceFormatData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AuthorizationPolicyResourceFormatData"/>. </summary>
        public AuthorizationPolicyResourceFormatData()
        {
            Permissions = new ChangeTrackingList<PermissionType>();
        }

        /// <summary> Initializes a new instance of <see cref="AuthorizationPolicyResourceFormatData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="policyName"> Name of the policy. </param>
        /// <param name="permissions"> The permissions associated with the policy. </param>
        /// <param name="primaryKey"> Primary key associated with the policy. </param>
        /// <param name="secondaryKey"> Secondary key associated with the policy. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AuthorizationPolicyResourceFormatData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string policyName, IList<PermissionType> permissions, string primaryKey, string secondaryKey, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            PolicyName = policyName;
            Permissions = permissions;
            PrimaryKey = primaryKey;
            SecondaryKey = secondaryKey;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Name of the policy. </summary>
        public string PolicyName { get; }
        /// <summary> The permissions associated with the policy. </summary>
        public IList<PermissionType> Permissions { get; }
        /// <summary> Primary key associated with the policy. </summary>
        public string PrimaryKey { get; set; }
        /// <summary> Secondary key associated with the policy. </summary>
        public string SecondaryKey { get; set; }
    }
}
