// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.CustomerInsights.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmCustomerInsightsModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="CustomerInsights.HubData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="apiEndpoint"> API endpoint URL of the hub. </param>
        /// <param name="webEndpoint"> Web endpoint URL of the hub. </param>
        /// <param name="provisioningState"> Provisioning state of the hub. </param>
        /// <param name="tenantFeatures"> The bit flags for enabled hub features. Bit 0 is set to 1 indicates graph is enabled, or disabled if set to 0. Bit 1 is set to 1 indicates the hub is disabled, or enabled if set to 0. </param>
        /// <param name="hubBillingInfo"> Billing settings of the hub. </param>
        /// <returns> A new <see cref="CustomerInsights.HubData"/> instance for mocking. </returns>
        public static HubData HubData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string apiEndpoint = null, string webEndpoint = null, string provisioningState = null, int? tenantFeatures = null, HubBillingInfoFormat hubBillingInfo = null)
        {
            tags ??= new Dictionary<string, string>();

            return new HubData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                apiEndpoint,
                webEndpoint,
                provisioningState,
                tenantFeatures,
                hubBillingInfo,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="CustomerInsights.ProfileResourceFormatData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="attributes"> The attributes for the Type. </param>
        /// <param name="description"> Localized descriptions for the property. </param>
        /// <param name="displayName"> Localized display names for the property. </param>
        /// <param name="localizedAttributes"> Any custom localized attributes for the Type. </param>
        /// <param name="smallImage"> Small Image associated with the Property or EntityType. </param>
        /// <param name="mediumImage"> Medium Image associated with the Property or EntityType. </param>
        /// <param name="largeImage"> Large Image associated with the Property or EntityType. </param>
        /// <param name="apiEntitySetName"> The api entity set name. This becomes the odata entity set name for the entity Type being referred in this object. </param>
        /// <param name="entityType"> Type of entity. </param>
        /// <param name="fields"> The properties of the Profile. </param>
        /// <param name="instancesCount"> The instance count. </param>
        /// <param name="lastChangedUtc"> The last changed time for the type definition. </param>
        /// <param name="provisioningState"> Provisioning state. </param>
        /// <param name="schemaItemTypeLink"> The schema org link. This helps ACI identify and suggest semantic models. </param>
        /// <param name="tenantId"> The hub name. </param>
        /// <param name="timestampFieldName"> The timestamp property name. Represents the time when the interaction or profile update happened. </param>
        /// <param name="typeName"> The name of the entity. </param>
        /// <param name="strongIds"> The strong IDs. </param>
        /// <returns> A new <see cref="CustomerInsights.ProfileResourceFormatData"/> instance for mocking. </returns>
        public static ProfileResourceFormatData ProfileResourceFormatData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, IList<string>> attributes = null, IDictionary<string, string> description = null, IDictionary<string, string> displayName = null, IDictionary<string, IDictionary<string, string>> localizedAttributes = null, string smallImage = null, string mediumImage = null, string largeImage = null, string apiEntitySetName = null, EntityType? entityType = null, IEnumerable<PropertyDefinition> fields = null, int? instancesCount = null, DateTimeOffset? lastChangedUtc = null, ProvisioningState? provisioningState = null, string schemaItemTypeLink = null, Guid? tenantId = null, string timestampFieldName = null, string typeName = null, IEnumerable<StrongId> strongIds = null)
        {
            attributes ??= new Dictionary<string, IList<string>>();
            description ??= new Dictionary<string, string>();
            displayName ??= new Dictionary<string, string>();
            localizedAttributes ??= new Dictionary<string, IDictionary<string, string>>();
            fields ??= new List<PropertyDefinition>();
            strongIds ??= new List<StrongId>();

            return new ProfileResourceFormatData(
                id,
                name,
                resourceType,
                systemData,
                attributes,
                description,
                displayName,
                localizedAttributes,
                smallImage,
                mediumImage,
                largeImage,
                apiEntitySetName,
                entityType,
                fields?.ToList(),
                instancesCount,
                lastChangedUtc,
                provisioningState,
                schemaItemTypeLink,
                tenantId,
                timestampFieldName,
                typeName,
                strongIds?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PropertyDefinition"/>. </summary>
        /// <param name="arrayValueSeparator"> Array value separator for properties with isArray set. </param>
        /// <param name="enumValidValues"> Describes valid values for an enum property. </param>
        /// <param name="fieldName"> Name of the property. </param>
        /// <param name="fieldType"> Type of the property. </param>
        /// <param name="isArray"> Indicates if the property is actually an array of the fieldType above on the data api. </param>
        /// <param name="isEnum"> Indicates if the property is an enum. </param>
        /// <param name="isFlagEnum"> Indicates if the property is an flag enum. </param>
        /// <param name="isImage"> Whether the property is an Image. </param>
        /// <param name="isLocalizedString"> Whether the property is a localized string. </param>
        /// <param name="isName"> Whether the property is a name or a part of name. </param>
        /// <param name="isRequired"> Whether property value is required on instances, IsRequired field only for Interaction. Profile Instance will not check for required field. </param>
        /// <param name="propertyId"> The ID associated with the property. </param>
        /// <param name="schemaItemPropLink"> URL encoded schema.org item prop link for the property. </param>
        /// <param name="maxLength"> Max length of string. Used only if type is string. </param>
        /// <param name="isAvailableInGraph"> Whether property is available in graph or not. </param>
        /// <param name="dataSourcePrecedenceRules"> This is specific to interactions modeled as activities. Data sources are used to determine where data is stored and also in precedence rules. </param>
        /// <returns> A new <see cref="Models.PropertyDefinition"/> instance for mocking. </returns>
        public static PropertyDefinition PropertyDefinition(string arrayValueSeparator = null, IEnumerable<ProfileEnumValidValuesFormat> enumValidValues = null, string fieldName = null, string fieldType = null, bool? isArray = null, bool? isEnum = null, bool? isFlagEnum = null, bool? isImage = null, bool? isLocalizedString = null, bool? isName = null, bool? isRequired = null, string propertyId = null, string schemaItemPropLink = null, int? maxLength = null, bool? isAvailableInGraph = null, IEnumerable<DataSourcePrecedence> dataSourcePrecedenceRules = null)
        {
            enumValidValues ??= new List<ProfileEnumValidValuesFormat>();
            dataSourcePrecedenceRules ??= new List<DataSourcePrecedence>();

            return new PropertyDefinition(
                arrayValueSeparator,
                enumValidValues?.ToList(),
                fieldName,
                fieldType,
                isArray,
                isEnum,
                isFlagEnum,
                isImage,
                isLocalizedString,
                isName,
                isRequired,
                propertyId,
                schemaItemPropLink,
                maxLength,
                isAvailableInGraph,
                dataSourcePrecedenceRules?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataSourcePrecedence"/>. </summary>
        /// <param name="precedence"> the precedence value. </param>
        /// <param name="name"> The data source name. </param>
        /// <param name="dataSourceType"> The data source type. </param>
        /// <param name="status"> The data source status. </param>
        /// <param name="id"> The data source ID. </param>
        /// <param name="dataSourceReferenceId"> The data source reference id. </param>
        /// <returns> A new <see cref="Models.DataSourcePrecedence"/> instance for mocking. </returns>
        public static DataSourcePrecedence DataSourcePrecedence(int? precedence = null, string name = null, DataSourceType? dataSourceType = null, Status? status = null, int? id = null, string dataSourceReferenceId = null)
        {
            return new DataSourcePrecedence(
                precedence,
                name,
                dataSourceType,
                status,
                id,
                dataSourceReferenceId,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.KpiDefinition"/>. </summary>
        /// <param name="entityType"> The mapping entity type. </param>
        /// <param name="entityTypeName"> The mapping entity name. </param>
        /// <param name="tenantId"> The hub name. </param>
        /// <param name="kpiName"> The KPI name. </param>
        /// <param name="displayName"> Localized display name for the KPI. </param>
        /// <param name="description"> Localized description for the KPI. </param>
        /// <param name="calculationWindow"> The calculation window. </param>
        /// <param name="calculationWindowFieldName"> Name of calculation window field. </param>
        /// <param name="function"> The computation function for the KPI. </param>
        /// <param name="expression"> The computation expression for the KPI. </param>
        /// <param name="unit"> The unit of measurement for the KPI. </param>
        /// <param name="filter"> The filter expression for the KPI. </param>
        /// <param name="groupBy"> the group by properties for the KPI. </param>
        /// <param name="groupByMetadata"> The KPI GroupByMetadata. </param>
        /// <param name="participantProfilesMetadata"> The participant profiles. </param>
        /// <param name="provisioningState"> Provisioning state. </param>
        /// <param name="thresHolds"> The KPI thresholds. </param>
        /// <param name="aliases"> The aliases. </param>
        /// <param name="extracts"> The KPI extracts. </param>
        /// <returns> A new <see cref="Models.KpiDefinition"/> instance for mocking. </returns>
        public static KpiDefinition KpiDefinition(EntityType entityType = default, string entityTypeName = null, Guid? tenantId = null, string kpiName = null, IReadOnlyDictionary<string, string> displayName = null, IReadOnlyDictionary<string, string> description = null, CalculationWindowType calculationWindow = default, string calculationWindowFieldName = null, KpiFunction function = default, string expression = null, string unit = null, string filter = null, IEnumerable<string> groupBy = null, IEnumerable<KpiGroupByMetadata> groupByMetadata = null, IEnumerable<KpiParticipantProfilesMetadata> participantProfilesMetadata = null, ProvisioningState? provisioningState = null, KpiThresholds thresHolds = null, IEnumerable<KpiAlias> aliases = null, IEnumerable<KpiExtract> extracts = null)
        {
            displayName ??= new Dictionary<string, string>();
            description ??= new Dictionary<string, string>();
            groupBy ??= new List<string>();
            groupByMetadata ??= new List<KpiGroupByMetadata>();
            participantProfilesMetadata ??= new List<KpiParticipantProfilesMetadata>();
            aliases ??= new List<KpiAlias>();
            extracts ??= new List<KpiExtract>();

            return new KpiDefinition(
                entityType,
                entityTypeName,
                tenantId,
                kpiName,
                displayName,
                description,
                calculationWindow,
                calculationWindowFieldName,
                function,
                expression,
                unit,
                filter,
                groupBy?.ToList(),
                groupByMetadata?.ToList(),
                participantProfilesMetadata?.ToList(),
                provisioningState,
                thresHolds,
                aliases?.ToList(),
                extracts?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.KpiGroupByMetadata"/>. </summary>
        /// <param name="displayName"> The display name. </param>
        /// <param name="fieldName"> The name of the field. </param>
        /// <param name="fieldType"> The type of the field. </param>
        /// <returns> A new <see cref="Models.KpiGroupByMetadata"/> instance for mocking. </returns>
        public static KpiGroupByMetadata KpiGroupByMetadata(IReadOnlyDictionary<string, string> displayName = null, string fieldName = null, string fieldType = null)
        {
            displayName ??= new Dictionary<string, string>();

            return new KpiGroupByMetadata(displayName, fieldName, fieldType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.KpiParticipantProfilesMetadata"/>. </summary>
        /// <param name="typeName"> Name of the type. </param>
        /// <returns> A new <see cref="Models.KpiParticipantProfilesMetadata"/> instance for mocking. </returns>
        public static KpiParticipantProfilesMetadata KpiParticipantProfilesMetadata(string typeName = null)
        {
            return new KpiParticipantProfilesMetadata(typeName, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="CustomerInsights.InteractionResourceFormatData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="attributes"> The attributes for the Type. </param>
        /// <param name="description"> Localized descriptions for the property. </param>
        /// <param name="displayName"> Localized display names for the property. </param>
        /// <param name="localizedAttributes"> Any custom localized attributes for the Type. </param>
        /// <param name="smallImage"> Small Image associated with the Property or EntityType. </param>
        /// <param name="mediumImage"> Medium Image associated with the Property or EntityType. </param>
        /// <param name="largeImage"> Large Image associated with the Property or EntityType. </param>
        /// <param name="apiEntitySetName"> The api entity set name. This becomes the odata entity set name for the entity Type being referred in this object. </param>
        /// <param name="entityType"> Type of entity. </param>
        /// <param name="fields"> The properties of the Profile. </param>
        /// <param name="instancesCount"> The instance count. </param>
        /// <param name="lastChangedUtc"> The last changed time for the type definition. </param>
        /// <param name="provisioningState"> Provisioning state. </param>
        /// <param name="schemaItemTypeLink"> The schema org link. This helps ACI identify and suggest semantic models. </param>
        /// <param name="tenantId"> The hub name. </param>
        /// <param name="timestampFieldName"> The timestamp property name. Represents the time when the interaction or profile update happened. </param>
        /// <param name="typeName"> The name of the entity. </param>
        /// <param name="idPropertyNames"> The id property names. Properties which uniquely identify an interaction instance. </param>
        /// <param name="participantProfiles"> Profiles that participated in the interaction. </param>
        /// <param name="primaryParticipantProfilePropertyName"> The primary participant property name for an interaction ,This is used to logically represent the agent of the interaction, Specify the participant name here from ParticipantName. </param>
        /// <param name="dataSourcePrecedenceRules"> This is specific to interactions modeled as activities. Data sources are used to determine where data is stored and also in precedence rules. </param>
        /// <param name="isActivity"> An interaction can be tagged as an activity only during create. This enables the interaction to be editable and can enable merging of properties from multiple data sources based on precedence, which is defined at a link level. </param>
        /// <param name="namePropertiesDefaultDataSourceName"> The data source name. </param>
        /// <param name="dataSourceType"> The data source type. </param>
        /// <param name="status"> The data source status. </param>
        /// <param name="idPropertiesDefaultDataSourceId"> The data source ID. </param>
        /// <param name="dataSourceReferenceId"> The data source reference id. </param>
        /// <returns> A new <see cref="CustomerInsights.InteractionResourceFormatData"/> instance for mocking. </returns>
        public static InteractionResourceFormatData InteractionResourceFormatData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, IList<string>> attributes = null, IDictionary<string, string> description = null, IDictionary<string, string> displayName = null, IDictionary<string, IDictionary<string, string>> localizedAttributes = null, string smallImage = null, string mediumImage = null, string largeImage = null, string apiEntitySetName = null, EntityType? entityType = null, IEnumerable<PropertyDefinition> fields = null, int? instancesCount = null, DateTimeOffset? lastChangedUtc = null, ProvisioningState? provisioningState = null, string schemaItemTypeLink = null, Guid? tenantId = null, string timestampFieldName = null, string typeName = null, IEnumerable<string> idPropertyNames = null, IEnumerable<Participant> participantProfiles = null, string primaryParticipantProfilePropertyName = null, IEnumerable<DataSourcePrecedence> dataSourcePrecedenceRules = null, bool? isActivity = null, string namePropertiesDefaultDataSourceName = null, DataSourceType? dataSourceType = null, Status? status = null, int? idPropertiesDefaultDataSourceId = null, string dataSourceReferenceId = null)
        {
            attributes ??= new Dictionary<string, IList<string>>();
            description ??= new Dictionary<string, string>();
            displayName ??= new Dictionary<string, string>();
            localizedAttributes ??= new Dictionary<string, IDictionary<string, string>>();
            fields ??= new List<PropertyDefinition>();
            idPropertyNames ??= new List<string>();
            participantProfiles ??= new List<Participant>();
            dataSourcePrecedenceRules ??= new List<DataSourcePrecedence>();

            return new InteractionResourceFormatData(
                id,
                name,
                resourceType,
                systemData,
                attributes,
                description,
                displayName,
                localizedAttributes,
                smallImage,
                mediumImage,
                largeImage,
                apiEntitySetName,
                entityType,
                fields?.ToList(),
                instancesCount,
                lastChangedUtc,
                provisioningState,
                schemaItemTypeLink,
                tenantId,
                timestampFieldName,
                typeName,
                idPropertyNames?.ToList(),
                participantProfiles?.ToList(),
                primaryParticipantProfilePropertyName,
                dataSourcePrecedenceRules?.ToList(),
                isActivity,
                namePropertiesDefaultDataSourceName,
                dataSourceType,
                status,
                idPropertiesDefaultDataSourceId,
                dataSourceReferenceId,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SuggestRelationshipLinksResponse"/>. </summary>
        /// <param name="interactionName"> The interaction name. </param>
        /// <param name="suggestedRelationships"> Suggested relationships for the type. </param>
        /// <returns> A new <see cref="Models.SuggestRelationshipLinksResponse"/> instance for mocking. </returns>
        public static SuggestRelationshipLinksResponse SuggestRelationshipLinksResponse(string interactionName = null, IEnumerable<RelationshipsLookup> suggestedRelationships = null)
        {
            suggestedRelationships ??= new List<RelationshipsLookup>();

            return new SuggestRelationshipLinksResponse(interactionName, suggestedRelationships?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RelationshipsLookup"/>. </summary>
        /// <param name="profileName"> The relationship profile. </param>
        /// <param name="profilePropertyReferences"> The property references for the profile type. </param>
        /// <param name="relatedProfileName"> The related profile. </param>
        /// <param name="relatedProfilePropertyReferences"> The property references for the related profile type. </param>
        /// <param name="existingRelationshipName"> The name of existing Relationship. </param>
        /// <returns> A new <see cref="Models.RelationshipsLookup"/> instance for mocking. </returns>
        public static RelationshipsLookup RelationshipsLookup(string profileName = null, IEnumerable<ParticipantProfilePropertyReference> profilePropertyReferences = null, string relatedProfileName = null, IEnumerable<ParticipantProfilePropertyReference> relatedProfilePropertyReferences = null, string existingRelationshipName = null)
        {
            profilePropertyReferences ??= new List<ParticipantProfilePropertyReference>();
            relatedProfilePropertyReferences ??= new List<ParticipantProfilePropertyReference>();

            return new RelationshipsLookup(
                profileName,
                profilePropertyReferences?.ToList(),
                relatedProfileName,
                relatedProfilePropertyReferences?.ToList(),
                existingRelationshipName,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="CustomerInsights.RelationshipResourceFormatData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="cardinality"> The Relationship Cardinality. </param>
        /// <param name="displayName"> Localized display name for the Relationship. </param>
        /// <param name="description"> Localized descriptions for the Relationship. </param>
        /// <param name="expiryDateTimeUtc"> The expiry date time in UTC. </param>
        /// <param name="fields"> The properties of the Relationship. </param>
        /// <param name="lookupMappings"> Optional property to be used to map fields in profile to their strong ids in related profile. </param>
        /// <param name="profileType"> Profile type. </param>
        /// <param name="provisioningState"> Provisioning state. </param>
        /// <param name="relationshipName"> The Relationship name. </param>
        /// <param name="relatedProfileType"> Related profile being referenced. </param>
        /// <param name="relationshipGuidId"> The relationship guid id. </param>
        /// <param name="tenantId"> The hub name. </param>
        /// <returns> A new <see cref="CustomerInsights.RelationshipResourceFormatData"/> instance for mocking. </returns>
        public static RelationshipResourceFormatData RelationshipResourceFormatData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, CardinalityType? cardinality = null, IDictionary<string, string> displayName = null, IDictionary<string, string> description = null, DateTimeOffset? expiryDateTimeUtc = null, IEnumerable<PropertyDefinition> fields = null, IEnumerable<RelationshipTypeMapping> lookupMappings = null, string profileType = null, ProvisioningState? provisioningState = null, string relationshipName = null, string relatedProfileType = null, string relationshipGuidId = null, Guid? tenantId = null)
        {
            displayName ??= new Dictionary<string, string>();
            description ??= new Dictionary<string, string>();
            fields ??= new List<PropertyDefinition>();
            lookupMappings ??= new List<RelationshipTypeMapping>();

            return new RelationshipResourceFormatData(
                id,
                name,
                resourceType,
                systemData,
                cardinality,
                displayName,
                description,
                expiryDateTimeUtc,
                fields?.ToList(),
                lookupMappings?.ToList(),
                profileType,
                provisioningState,
                relationshipName,
                relatedProfileType,
                relationshipGuidId,
                tenantId,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="CustomerInsights.RelationshipLinkResourceFormatData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="displayName"> Localized display name for the Relationship Link. </param>
        /// <param name="description"> Localized descriptions for the Relationship Link. </param>
        /// <param name="interactionType"> The InteractionType associated with the Relationship Link. </param>
        /// <param name="linkName"> The name of the Relationship Link. </param>
        /// <param name="mappings"> The mappings between Interaction and Relationship fields. </param>
        /// <param name="profilePropertyReferences"> The property references for the Profile of the Relationship. </param>
        /// <param name="provisioningState"> Provisioning state. </param>
        /// <param name="relatedProfilePropertyReferences"> The property references for the Related Profile of the Relationship. </param>
        /// <param name="relationshipName"> The Relationship associated with the Link. </param>
        /// <param name="relationshipGuidId"> The relationship guid id. </param>
        /// <param name="tenantId"> The hub name. </param>
        /// <returns> A new <see cref="CustomerInsights.RelationshipLinkResourceFormatData"/> instance for mocking. </returns>
        public static RelationshipLinkResourceFormatData RelationshipLinkResourceFormatData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> displayName = null, IDictionary<string, string> description = null, string interactionType = null, string linkName = null, IEnumerable<RelationshipLinkFieldMapping> mappings = null, IEnumerable<ParticipantProfilePropertyReference> profilePropertyReferences = null, ProvisioningState? provisioningState = null, IEnumerable<ParticipantProfilePropertyReference> relatedProfilePropertyReferences = null, string relationshipName = null, string relationshipGuidId = null, Guid? tenantId = null)
        {
            displayName ??= new Dictionary<string, string>();
            description ??= new Dictionary<string, string>();
            mappings ??= new List<RelationshipLinkFieldMapping>();
            profilePropertyReferences ??= new List<ParticipantProfilePropertyReference>();
            relatedProfilePropertyReferences ??= new List<ParticipantProfilePropertyReference>();

            return new RelationshipLinkResourceFormatData(
                id,
                name,
                resourceType,
                systemData,
                displayName,
                description,
                interactionType,
                linkName,
                mappings?.ToList(),
                profilePropertyReferences?.ToList(),
                provisioningState,
                relatedProfilePropertyReferences?.ToList(),
                relationshipName,
                relationshipGuidId,
                tenantId,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="CustomerInsights.AuthorizationPolicyResourceFormatData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="policyName"> Name of the policy. </param>
        /// <param name="permissions"> The permissions associated with the policy. </param>
        /// <param name="primaryKey"> Primary key associated with the policy. </param>
        /// <param name="secondaryKey"> Secondary key associated with the policy. </param>
        /// <returns> A new <see cref="CustomerInsights.AuthorizationPolicyResourceFormatData"/> instance for mocking. </returns>
        public static AuthorizationPolicyResourceFormatData AuthorizationPolicyResourceFormatData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string policyName = null, IEnumerable<PermissionType> permissions = null, string primaryKey = null, string secondaryKey = null)
        {
            permissions ??= new List<PermissionType>();

            return new AuthorizationPolicyResourceFormatData(
                id,
                name,
                resourceType,
                systemData,
                policyName,
                permissions?.ToList(),
                primaryKey,
                secondaryKey,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AuthorizationPolicy"/>. </summary>
        /// <param name="policyName"> Name of the policy. </param>
        /// <param name="permissions"> The permissions associated with the policy. </param>
        /// <param name="primaryKey"> Primary key associated with the policy. </param>
        /// <param name="secondaryKey"> Secondary key associated with the policy. </param>
        /// <returns> A new <see cref="Models.AuthorizationPolicy"/> instance for mocking. </returns>
        public static AuthorizationPolicy AuthorizationPolicy(string policyName = null, IEnumerable<PermissionType> permissions = null, string primaryKey = null, string secondaryKey = null)
        {
            permissions ??= new List<PermissionType>();

            return new AuthorizationPolicy(policyName, permissions?.ToList(), primaryKey, secondaryKey, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="CustomerInsights.ConnectorResourceFormatData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="connectorId"> ID of the connector. </param>
        /// <param name="connectorName"> Name of the connector. </param>
        /// <param name="connectorType"> Type of connector. </param>
        /// <param name="displayName"> Display name of the connector. </param>
        /// <param name="description"> Description of the connector. </param>
        /// <param name="connectorProperties"> The connector properties. </param>
        /// <param name="created"> The created time. </param>
        /// <param name="lastModified"> The last modified time. </param>
        /// <param name="state"> State of connector. </param>
        /// <param name="tenantId"> The hub name. </param>
        /// <param name="isInternal"> If this is an internal connector. </param>
        /// <returns> A new <see cref="CustomerInsights.ConnectorResourceFormatData"/> instance for mocking. </returns>
        public static ConnectorResourceFormatData ConnectorResourceFormatData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, int? connectorId = null, string connectorName = null, ConnectorType? connectorType = null, string displayName = null, string description = null, IDictionary<string, BinaryData> connectorProperties = null, DateTimeOffset? created = null, DateTimeOffset? lastModified = null, ConnectorState? state = null, Guid? tenantId = null, bool? isInternal = null)
        {
            connectorProperties ??= new Dictionary<string, BinaryData>();

            return new ConnectorResourceFormatData(
                id,
                name,
                resourceType,
                systemData,
                connectorId,
                connectorName,
                connectorType,
                displayName,
                description,
                connectorProperties,
                created,
                lastModified,
                state,
                tenantId,
                isInternal,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="CustomerInsights.ConnectorMappingResourceFormatData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="connectorName"> The connector name. </param>
        /// <param name="connectorType"> Type of connector. </param>
        /// <param name="created"> The created time. </param>
        /// <param name="lastModified"> The last modified time. </param>
        /// <param name="entityType"> Defines which entity type the file should map to. </param>
        /// <param name="entityTypeName"> The mapping entity name. </param>
        /// <param name="connectorMappingName"> The connector mapping name. </param>
        /// <param name="displayName"> Display name for the connector mapping. </param>
        /// <param name="description"> The description of the connector mapping. </param>
        /// <param name="dataFormatId"> The DataFormat ID. </param>
        /// <param name="mappingProperties"> The properties of the mapping. </param>
        /// <param name="nextRunOn"> The next run time based on customer's settings. </param>
        /// <param name="runId"> The RunId. </param>
        /// <param name="state"> State of connector mapping. </param>
        /// <param name="tenantId"> The hub name. </param>
        /// <returns> A new <see cref="CustomerInsights.ConnectorMappingResourceFormatData"/> instance for mocking. </returns>
        public static ConnectorMappingResourceFormatData ConnectorMappingResourceFormatData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string connectorName = null, ConnectorType? connectorType = null, DateTimeOffset? created = null, DateTimeOffset? lastModified = null, EntityType? entityType = null, string entityTypeName = null, string connectorMappingName = null, string displayName = null, string description = null, string dataFormatId = null, ConnectorMappingProperties mappingProperties = null, DateTimeOffset? nextRunOn = null, string runId = null, ConnectorMappingState? state = null, Guid? tenantId = null)
        {
            return new ConnectorMappingResourceFormatData(
                id,
                name,
                resourceType,
                systemData,
                connectorName,
                connectorType,
                created,
                lastModified,
                entityType,
                entityTypeName,
                connectorMappingName,
                displayName,
                description,
                dataFormatId,
                mappingProperties,
                nextRunOn,
                runId,
                state,
                tenantId,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConnectorMappingFormat"/>. </summary>
        /// <param name="formatType"> The type mapping format. </param>
        /// <param name="columnDelimiter"> The character that signifies a break between columns. </param>
        /// <param name="acceptLanguage"> The oData language. </param>
        /// <param name="quoteCharacter"> Quote character, used to indicate enquoted fields. </param>
        /// <param name="quoteEscapeCharacter"> Escape character for quotes, can be the same as the quoteCharacter. </param>
        /// <param name="arraySeparator"> Character separating array elements. </param>
        /// <returns> A new <see cref="Models.ConnectorMappingFormat"/> instance for mocking. </returns>
        public static ConnectorMappingFormat ConnectorMappingFormat(FormatType formatType = default, string columnDelimiter = null, string acceptLanguage = null, string quoteCharacter = null, string quoteEscapeCharacter = null, string arraySeparator = null)
        {
            return new ConnectorMappingFormat(
                formatType,
                columnDelimiter,
                acceptLanguage,
                quoteCharacter,
                quoteEscapeCharacter,
                arraySeparator,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="CustomerInsights.KpiResourceFormatData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="entityType"> The mapping entity type. </param>
        /// <param name="entityTypeName"> The mapping entity name. </param>
        /// <param name="tenantId"> The hub name. </param>
        /// <param name="kpiName"> The KPI name. </param>
        /// <param name="displayName"> Localized display name for the KPI. </param>
        /// <param name="description"> Localized description for the KPI. </param>
        /// <param name="calculationWindow"> The calculation window. </param>
        /// <param name="calculationWindowFieldName"> Name of calculation window field. </param>
        /// <param name="function"> The computation function for the KPI. </param>
        /// <param name="expression"> The computation expression for the KPI. </param>
        /// <param name="unit"> The unit of measurement for the KPI. </param>
        /// <param name="filter"> The filter expression for the KPI. </param>
        /// <param name="groupBy"> the group by properties for the KPI. </param>
        /// <param name="groupByMetadata"> The KPI GroupByMetadata. </param>
        /// <param name="participantProfilesMetadata"> The participant profiles. </param>
        /// <param name="provisioningState"> Provisioning state. </param>
        /// <param name="thresHolds"> The KPI thresholds. </param>
        /// <param name="aliases"> The aliases. </param>
        /// <param name="extracts"> The KPI extracts. </param>
        /// <returns> A new <see cref="CustomerInsights.KpiResourceFormatData"/> instance for mocking. </returns>
        public static KpiResourceFormatData KpiResourceFormatData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, EntityType? entityType = null, string entityTypeName = null, Guid? tenantId = null, string kpiName = null, IDictionary<string, string> displayName = null, IDictionary<string, string> description = null, CalculationWindowType? calculationWindow = null, string calculationWindowFieldName = null, KpiFunction? function = null, string expression = null, string unit = null, string filter = null, IEnumerable<string> groupBy = null, IEnumerable<KpiGroupByMetadata> groupByMetadata = null, IEnumerable<KpiParticipantProfilesMetadata> participantProfilesMetadata = null, ProvisioningState? provisioningState = null, KpiThresholds thresHolds = null, IEnumerable<KpiAlias> aliases = null, IEnumerable<KpiExtract> extracts = null)
        {
            displayName ??= new Dictionary<string, string>();
            description ??= new Dictionary<string, string>();
            groupBy ??= new List<string>();
            groupByMetadata ??= new List<KpiGroupByMetadata>();
            participantProfilesMetadata ??= new List<KpiParticipantProfilesMetadata>();
            aliases ??= new List<KpiAlias>();
            extracts ??= new List<KpiExtract>();

            return new KpiResourceFormatData(
                id,
                name,
                resourceType,
                systemData,
                entityType,
                entityTypeName,
                tenantId,
                kpiName,
                displayName,
                description,
                calculationWindow,
                calculationWindowFieldName,
                function,
                expression,
                unit,
                filter,
                groupBy?.ToList(),
                groupByMetadata?.ToList(),
                participantProfilesMetadata?.ToList(),
                provisioningState,
                thresHolds,
                aliases?.ToList(),
                extracts?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="CustomerInsights.WidgetTypeResourceFormatData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="widgetTypeName"> Name of the widget type. </param>
        /// <param name="definition"> Definition for widget type. </param>
        /// <param name="description"> Description for widget type. </param>
        /// <param name="displayName"> Localized display name for the widget type. </param>
        /// <param name="imageUri"> The image URL. </param>
        /// <param name="tenantId"> The hub name. </param>
        /// <param name="widgetVersion"> The widget version. </param>
        /// <param name="changed"> Date time when widget type was last modified. </param>
        /// <param name="created"> Date time when widget type was created. </param>
        /// <returns> A new <see cref="CustomerInsights.WidgetTypeResourceFormatData"/> instance for mocking. </returns>
        public static WidgetTypeResourceFormatData WidgetTypeResourceFormatData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string widgetTypeName = null, string definition = null, string description = null, IDictionary<string, string> displayName = null, Uri imageUri = null, Guid? tenantId = null, string widgetVersion = null, DateTimeOffset? changed = null, DateTimeOffset? created = null)
        {
            displayName ??= new Dictionary<string, string>();

            return new WidgetTypeResourceFormatData(
                id,
                name,
                resourceType,
                systemData,
                widgetTypeName,
                definition,
                description,
                displayName,
                imageUri,
                tenantId,
                widgetVersion,
                changed,
                created,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="CustomerInsights.ViewResourceFormatData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="viewName"> Name of the view. </param>
        /// <param name="userId"> the user ID. </param>
        /// <param name="tenantId"> the hub name. </param>
        /// <param name="displayName"> Localized display name for the view. </param>
        /// <param name="definition"> View definition. </param>
        /// <param name="changed"> Date time when view was last modified. </param>
        /// <param name="created"> Date time when view was created. </param>
        /// <returns> A new <see cref="CustomerInsights.ViewResourceFormatData"/> instance for mocking. </returns>
        public static ViewResourceFormatData ViewResourceFormatData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string viewName = null, string userId = null, Guid? tenantId = null, IDictionary<string, string> displayName = null, string definition = null, DateTimeOffset? changed = null, DateTimeOffset? created = null)
        {
            displayName ??= new Dictionary<string, string>();

            return new ViewResourceFormatData(
                id,
                name,
                resourceType,
                systemData,
                viewName,
                userId,
                tenantId,
                displayName,
                definition,
                changed,
                created,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="CustomerInsights.LinkResourceFormatData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tenantId"> The hub name. </param>
        /// <param name="linkName"> The link name. </param>
        /// <param name="sourceEntityType"> Type of source entity. </param>
        /// <param name="targetEntityType"> Type of target entity. </param>
        /// <param name="sourceEntityTypeName"> Name of the source Entity Type. </param>
        /// <param name="targetEntityTypeName"> Name of the target Entity Type. </param>
        /// <param name="displayName"> Localized display name for the Link. </param>
        /// <param name="description"> Localized descriptions for the Link. </param>
        /// <param name="mappings"> The set of properties mappings between the source and target Types. </param>
        /// <param name="participantPropertyReferences"> The properties that represent the participating profile. </param>
        /// <param name="provisioningState"> Provisioning state. </param>
        /// <param name="referenceOnly"> Indicating whether the link is reference only link. This flag is ignored if the Mappings are defined. If the mappings are not defined and it is set to true, links processing will not create or update profiles. </param>
        /// <param name="operationType"> Determines whether this link is supposed to create or delete instances if Link is NOT Reference Only. </param>
        /// <returns> A new <see cref="CustomerInsights.LinkResourceFormatData"/> instance for mocking. </returns>
        public static LinkResourceFormatData LinkResourceFormatData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, Guid? tenantId = null, string linkName = null, EntityType? sourceEntityType = null, EntityType? targetEntityType = null, string sourceEntityTypeName = null, string targetEntityTypeName = null, IDictionary<string, string> displayName = null, IDictionary<string, string> description = null, IEnumerable<TypePropertiesMapping> mappings = null, IEnumerable<ParticipantPropertyReference> participantPropertyReferences = null, ProvisioningState? provisioningState = null, bool? referenceOnly = null, InstanceOperationType? operationType = null)
        {
            displayName ??= new Dictionary<string, string>();
            description ??= new Dictionary<string, string>();
            mappings ??= new List<TypePropertiesMapping>();
            participantPropertyReferences ??= new List<ParticipantPropertyReference>();

            return new LinkResourceFormatData(
                id,
                name,
                resourceType,
                systemData,
                tenantId,
                linkName,
                sourceEntityType,
                targetEntityType,
                sourceEntityTypeName,
                targetEntityTypeName,
                displayName,
                description,
                mappings?.ToList(),
                participantPropertyReferences?.ToList(),
                provisioningState,
                referenceOnly,
                operationType,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RoleResourceFormat"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="roleName"> The role name. </param>
        /// <param name="description"> The description of the role. </param>
        /// <returns> A new <see cref="Models.RoleResourceFormat"/> instance for mocking. </returns>
        public static RoleResourceFormat RoleResourceFormat(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string roleName = null, string description = null)
        {
            return new RoleResourceFormat(
                id,
                name,
                resourceType,
                systemData,
                roleName,
                description,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="CustomerInsights.RoleAssignmentResourceFormatData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tenantId"> The hub name. </param>
        /// <param name="assignmentName"> The name of the metadata object. </param>
        /// <param name="displayName"> Localized display names for the metadata. </param>
        /// <param name="description"> Localized description for the metadata. </param>
        /// <param name="provisioningState"> Provisioning state. </param>
        /// <param name="role"> Type of roles. </param>
        /// <param name="principals"> The principals being assigned to. </param>
        /// <param name="profiles"> Profiles set for the assignment. </param>
        /// <param name="interactions"> Interactions set for the assignment. </param>
        /// <param name="links"> Links set for the assignment. </param>
        /// <param name="kpis"> Kpis set for the assignment. </param>
        /// <param name="sasPolicies"> Sas Policies set for the assignment. </param>
        /// <param name="connectors"> Connectors set for the assignment. </param>
        /// <param name="views"> Views set for the assignment. </param>
        /// <param name="relationshipLinks"> The Role assignments set for the relationship links. </param>
        /// <param name="relationships"> The Role assignments set for the relationships. </param>
        /// <param name="widgetTypes"> Widget types set for the assignment. </param>
        /// <param name="roleAssignments"> The Role assignments set for the assignment. </param>
        /// <param name="conflationPolicies"> Widget types set for the assignment. </param>
        /// <param name="segments"> The Role assignments set for the assignment. </param>
        /// <returns> A new <see cref="CustomerInsights.RoleAssignmentResourceFormatData"/> instance for mocking. </returns>
        public static RoleAssignmentResourceFormatData RoleAssignmentResourceFormatData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, Guid? tenantId = null, string assignmentName = null, IDictionary<string, string> displayName = null, IDictionary<string, string> description = null, ProvisioningState? provisioningState = null, RoleType? role = null, IEnumerable<AssignmentPrincipal> principals = null, ResourceSetDescription profiles = null, ResourceSetDescription interactions = null, ResourceSetDescription links = null, ResourceSetDescription kpis = null, ResourceSetDescription sasPolicies = null, ResourceSetDescription connectors = null, ResourceSetDescription views = null, ResourceSetDescription relationshipLinks = null, ResourceSetDescription relationships = null, ResourceSetDescription widgetTypes = null, ResourceSetDescription roleAssignments = null, ResourceSetDescription conflationPolicies = null, ResourceSetDescription segments = null)
        {
            displayName ??= new Dictionary<string, string>();
            description ??= new Dictionary<string, string>();
            principals ??= new List<AssignmentPrincipal>();

            return new RoleAssignmentResourceFormatData(
                id,
                name,
                resourceType,
                systemData,
                tenantId,
                assignmentName,
                displayName,
                description,
                provisioningState,
                role,
                principals?.ToList(),
                profiles,
                interactions,
                links,
                kpis,
                sasPolicies,
                connectors,
                views,
                relationshipLinks,
                relationships,
                widgetTypes,
                roleAssignments,
                conflationPolicies,
                segments,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ImageDefinition"/>. </summary>
        /// <param name="imageExists"> Whether image exists already. </param>
        /// <param name="contentUri"> Content URL for the image blob. </param>
        /// <param name="relativePath"> Relative path of the image. </param>
        /// <returns> A new <see cref="Models.ImageDefinition"/> instance for mocking. </returns>
        public static ImageDefinition ImageDefinition(bool? imageExists = null, Uri contentUri = null, string relativePath = null)
        {
            return new ImageDefinition(imageExists, contentUri, relativePath, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="CustomerInsights.PredictionResourceFormatData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="description"> Description of the prediction. </param>
        /// <param name="displayName"> Display name of the prediction. </param>
        /// <param name="involvedInteractionTypes"> Interaction types involved in the prediction. </param>
        /// <param name="involvedKpiTypes"> KPI types involved in the prediction. </param>
        /// <param name="involvedRelationships"> Relationships involved in the prediction. </param>
        /// <param name="negativeOutcomeExpression"> Negative outcome expression. </param>
        /// <param name="positiveOutcomeExpression"> Positive outcome expression. </param>
        /// <param name="primaryProfileType"> Primary profile type. </param>
        /// <param name="provisioningState"> Provisioning state. </param>
        /// <param name="predictionName"> Name of the prediction. </param>
        /// <param name="scopeExpression"> Scope expression. </param>
        /// <param name="tenantId"> The hub name. </param>
        /// <param name="autoAnalyze"> Whether do auto analyze. </param>
        /// <param name="mappings"> Definition of the link mapping of prediction. </param>
        /// <param name="scoreLabel"> Score label. </param>
        /// <param name="grades"> The prediction grades. </param>
        /// <param name="systemGeneratedEntities"> System generated entities. </param>
        /// <returns> A new <see cref="CustomerInsights.PredictionResourceFormatData"/> instance for mocking. </returns>
        public static PredictionResourceFormatData PredictionResourceFormatData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> description = null, IDictionary<string, string> displayName = null, IEnumerable<string> involvedInteractionTypes = null, IEnumerable<string> involvedKpiTypes = null, IEnumerable<string> involvedRelationships = null, string negativeOutcomeExpression = null, string positiveOutcomeExpression = null, string primaryProfileType = null, ProvisioningState? provisioningState = null, string predictionName = null, string scopeExpression = null, Guid? tenantId = null, bool? autoAnalyze = null, PredictionMappings mappings = null, string scoreLabel = null, IEnumerable<PredictionGradesItem> grades = null, PredictionSystemGeneratedEntities systemGeneratedEntities = null)
        {
            description ??= new Dictionary<string, string>();
            displayName ??= new Dictionary<string, string>();
            involvedInteractionTypes ??= new List<string>();
            involvedKpiTypes ??= new List<string>();
            involvedRelationships ??= new List<string>();
            grades ??= new List<PredictionGradesItem>();

            return new PredictionResourceFormatData(
                id,
                name,
                resourceType,
                systemData,
                description,
                displayName,
                involvedInteractionTypes?.ToList(),
                involvedKpiTypes?.ToList(),
                involvedRelationships?.ToList(),
                negativeOutcomeExpression,
                positiveOutcomeExpression,
                primaryProfileType,
                provisioningState,
                predictionName,
                scopeExpression,
                tenantId,
                autoAnalyze,
                mappings,
                scoreLabel,
                grades?.ToList(),
                systemGeneratedEntities,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PredictionSystemGeneratedEntities"/>. </summary>
        /// <param name="generatedInteractionTypes"> Generated interaction types. </param>
        /// <param name="generatedLinks"> Generated links. </param>
        /// <param name="generatedKpis"> Generated KPIs. </param>
        /// <returns> A new <see cref="Models.PredictionSystemGeneratedEntities"/> instance for mocking. </returns>
        public static PredictionSystemGeneratedEntities PredictionSystemGeneratedEntities(IEnumerable<string> generatedInteractionTypes = null, IEnumerable<string> generatedLinks = null, IReadOnlyDictionary<string, string> generatedKpis = null)
        {
            generatedInteractionTypes ??= new List<string>();
            generatedLinks ??= new List<string>();
            generatedKpis ??= new Dictionary<string, string>();

            return new PredictionSystemGeneratedEntities(generatedInteractionTypes?.ToList(), generatedLinks?.ToList(), generatedKpis, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PredictionTrainingResults"/>. </summary>
        /// <param name="tenantId"> The hub name. </param>
        /// <param name="scoreName"> Score name. </param>
        /// <param name="predictionDistribution"> Prediction distribution. </param>
        /// <param name="canonicalProfiles"> Canonical profiles. </param>
        /// <param name="primaryProfileInstanceCount"> Instance count of the primary profile. </param>
        /// <returns> A new <see cref="Models.PredictionTrainingResults"/> instance for mocking. </returns>
        public static PredictionTrainingResults PredictionTrainingResults(Guid? tenantId = null, string scoreName = null, PredictionDistributionDefinition predictionDistribution = null, IEnumerable<CanonicalProfileDefinition> canonicalProfiles = null, long? primaryProfileInstanceCount = null)
        {
            canonicalProfiles ??= new List<CanonicalProfileDefinition>();

            return new PredictionTrainingResults(
                tenantId,
                scoreName,
                predictionDistribution,
                canonicalProfiles?.ToList(),
                primaryProfileInstanceCount,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PredictionDistributionDefinition"/>. </summary>
        /// <param name="totalPositives"> Total positive in the distribution. </param>
        /// <param name="totalNegatives"> Total negatives in the distribution. </param>
        /// <param name="distributions"> Distributions of the prediction. </param>
        /// <returns> A new <see cref="Models.PredictionDistributionDefinition"/> instance for mocking. </returns>
        public static PredictionDistributionDefinition PredictionDistributionDefinition(long? totalPositives = null, long? totalNegatives = null, IEnumerable<PredictionDistributionDefinitionDistributionsItem> distributions = null)
        {
            distributions ??= new List<PredictionDistributionDefinitionDistributionsItem>();

            return new PredictionDistributionDefinition(totalPositives, totalNegatives, distributions?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PredictionDistributionDefinitionDistributionsItem"/>. </summary>
        /// <param name="scoreThreshold"> Score threshold. </param>
        /// <param name="positives"> Number of positives. </param>
        /// <param name="negatives"> Number of negatives. </param>
        /// <param name="positivesAboveThreshold"> Number of positives above threshold. </param>
        /// <param name="negativesAboveThreshold"> Number of negatives above threshold. </param>
        /// <returns> A new <see cref="Models.PredictionDistributionDefinitionDistributionsItem"/> instance for mocking. </returns>
        public static PredictionDistributionDefinitionDistributionsItem PredictionDistributionDefinitionDistributionsItem(int? scoreThreshold = null, long? positives = null, long? negatives = null, long? positivesAboveThreshold = null, long? negativesAboveThreshold = null)
        {
            return new PredictionDistributionDefinitionDistributionsItem(
                scoreThreshold,
                positives,
                negatives,
                positivesAboveThreshold,
                negativesAboveThreshold,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CanonicalProfileDefinition"/>. </summary>
        /// <param name="canonicalProfileId"> Canonical profile ID. </param>
        /// <param name="properties"> Properties of the canonical profile. </param>
        /// <returns> A new <see cref="Models.CanonicalProfileDefinition"/> instance for mocking. </returns>
        public static CanonicalProfileDefinition CanonicalProfileDefinition(int? canonicalProfileId = null, IEnumerable<CanonicalProfileDefinitionPropertiesItem> properties = null)
        {
            properties ??= new List<CanonicalProfileDefinitionPropertiesItem>();

            return new CanonicalProfileDefinition(canonicalProfileId, properties?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CanonicalProfileDefinitionPropertiesItem"/>. </summary>
        /// <param name="profileName"> Profile name. </param>
        /// <param name="profilePropertyName"> Property name of profile. </param>
        /// <param name="rank"> The rank. </param>
        /// <param name="valueType"> Type of canonical property value. </param>
        /// <param name="value"> Value of the canonical property. </param>
        /// <returns> A new <see cref="Models.CanonicalProfileDefinitionPropertiesItem"/> instance for mocking. </returns>
        public static CanonicalProfileDefinitionPropertiesItem CanonicalProfileDefinitionPropertiesItem(string profileName = null, string profilePropertyName = null, int? rank = null, CanonicalPropertyValueType? valueType = null, string value = null)
        {
            return new CanonicalProfileDefinitionPropertiesItem(
                profileName,
                profilePropertyName,
                rank,
                valueType,
                value,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PredictionModelStatus"/>. </summary>
        /// <param name="tenantId"> The hub name. </param>
        /// <param name="predictionName"> The prediction name. </param>
        /// <param name="predictionGuidId"> The prediction GUID ID. </param>
        /// <param name="status"> Prediction model life cycle.  When prediction is in PendingModelConfirmation status, it is allowed to update the status to PendingFeaturing or Active through API. </param>
        /// <param name="message"> The model status message. </param>
        /// <param name="trainingSetCount"> Count of the training set. </param>
        /// <param name="testSetCount"> Count of the test set. </param>
        /// <param name="validationSetCount"> Count of the validation set. </param>
        /// <param name="trainingAccuracy"> The training accuracy. </param>
        /// <param name="signalsUsed"> The signals used. </param>
        /// <param name="modelVersion"> Version of the model. </param>
        /// <returns> A new <see cref="Models.PredictionModelStatus"/> instance for mocking. </returns>
        public static PredictionModelStatus PredictionModelStatus(Guid? tenantId = null, string predictionName = null, string predictionGuidId = null, PredictionModelLifeCycle status = default, string message = null, int? trainingSetCount = null, int? testSetCount = null, int? validationSetCount = null, decimal? trainingAccuracy = null, int? signalsUsed = null, string modelVersion = null)
        {
            return new PredictionModelStatus(
                tenantId,
                predictionName,
                predictionGuidId,
                status,
                message,
                trainingSetCount,
                testSetCount,
                validationSetCount,
                trainingAccuracy,
                signalsUsed,
                modelVersion,
                serializedAdditionalRawData: null);
        }
    }
}
