// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.CustomerInsights.Models;

namespace Azure.ResourceManager.CustomerInsights.Samples
{
    public partial class Sample_InteractionResourceFormatResource
    {
        // Interactions_CreateOrUpdate
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_InteractionsCreateOrUpdate()
        {
            // Generated from example definition: specification/customer-insights/resource-manager/Microsoft.CustomerInsights/stable/2017-04-26/examples/InteractionsCreateOrUpdate.json
            // this example is just showing the usage of "Interactions_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this InteractionResourceFormatResource created on azure
            // for more information of creating InteractionResourceFormatResource, please refer to the document of InteractionResourceFormatResource
            string subscriptionId = "subid";
            string resourceGroupName = "TestHubRG";
            string hubName = "sdkTestHub";
            string interactionName = "TestProfileType396";
            ResourceIdentifier interactionResourceFormatResourceId = InteractionResourceFormatResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, hubName, interactionName);
            InteractionResourceFormatResource interactionResourceFormat = client.GetInteractionResourceFormatResource(interactionResourceFormatResourceId);

            // invoke the operation
            InteractionResourceFormatData data = new InteractionResourceFormatData()
            {
                SmallImage = "\\\\Images\\\\smallImage",
                MediumImage = "\\\\Images\\\\MediumImage",
                LargeImage = "\\\\Images\\\\LargeImage",
                ApiEntitySetName = "TestInteractionType6358",
                Fields =
{
new PropertyDefinition("TestInteractionType6358","Edm.String")
{
IsArray = false,
IsRequired = true,
},new PropertyDefinition("profile1","Edm.String")
},
                IdPropertyNames =
{
"TestInteractionType6358"
},
                PrimaryParticipantProfilePropertyName = "profile1",
            };
            ArmOperation<InteractionResourceFormatResource> lro = await interactionResourceFormat.UpdateAsync(WaitUntil.Completed, data);
            InteractionResourceFormatResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            InteractionResourceFormatData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Interactions_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_InteractionsGet()
        {
            // Generated from example definition: specification/customer-insights/resource-manager/Microsoft.CustomerInsights/stable/2017-04-26/examples/InteractionsGet.json
            // this example is just showing the usage of "Interactions_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this InteractionResourceFormatResource created on azure
            // for more information of creating InteractionResourceFormatResource, please refer to the document of InteractionResourceFormatResource
            string subscriptionId = "subid";
            string resourceGroupName = "TestHubRG";
            string hubName = "sdkTestHub";
            string interactionName = "TestInteractionType6358";
            ResourceIdentifier interactionResourceFormatResourceId = InteractionResourceFormatResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, hubName, interactionName);
            InteractionResourceFormatResource interactionResourceFormat = client.GetInteractionResourceFormatResource(interactionResourceFormatResourceId);

            // invoke the operation
            InteractionResourceFormatResource result = await interactionResourceFormat.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            InteractionResourceFormatData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Interactions_SuggestRelationshipLinks
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task SuggestRelationshipLinks_InteractionsSuggestRelationshipLinks()
        {
            // Generated from example definition: specification/customer-insights/resource-manager/Microsoft.CustomerInsights/stable/2017-04-26/examples/InteractionsSuggestRelationshipLinks.json
            // this example is just showing the usage of "Interactions_SuggestRelationshipLinks" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this InteractionResourceFormatResource created on azure
            // for more information of creating InteractionResourceFormatResource, please refer to the document of InteractionResourceFormatResource
            string subscriptionId = "subid";
            string resourceGroupName = "TestHubRG";
            string hubName = "sdkTestHub";
            string interactionName = "Deposit";
            ResourceIdentifier interactionResourceFormatResourceId = InteractionResourceFormatResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, hubName, interactionName);
            InteractionResourceFormatResource interactionResourceFormat = client.GetInteractionResourceFormatResource(interactionResourceFormatResourceId);

            // invoke the operation
            SuggestRelationshipLinksResponse result = await interactionResourceFormat.SuggestRelationshipLinksAsync();

            Console.WriteLine($"Succeeded: {result}");
        }
    }
}
