// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.CustomerInsights.Models;

namespace Azure.ResourceManager.CustomerInsights.Samples
{
    public partial class Sample_ConnectorResourceFormatResource
    {
        // Connectors_CreateOrUpdate
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_ConnectorsCreateOrUpdate()
        {
            // Generated from example definition: specification/customer-insights/resource-manager/Microsoft.CustomerInsights/stable/2017-04-26/examples/ConnectorsCreateOrUpdate.json
            // this example is just showing the usage of "Connectors_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ConnectorResourceFormatResource created on azure
            // for more information of creating ConnectorResourceFormatResource, please refer to the document of ConnectorResourceFormatResource
            string subscriptionId = "subid";
            string resourceGroupName = "TestHubRG";
            string hubName = "sdkTestHub";
            string connectorName = "testConnector";
            ResourceIdentifier connectorResourceFormatResourceId = ConnectorResourceFormatResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, hubName, connectorName);
            ConnectorResourceFormatResource connectorResourceFormat = client.GetConnectorResourceFormatResource(connectorResourceFormatResourceId);

            // invoke the operation
            ConnectorResourceFormatData data = new ConnectorResourceFormatData()
            {
                ConnectorType = ConnectorType.AzureBlob,
                DisplayName = "testConnector",
                Description = "Test connector",
                ConnectorProperties =
{
["connectionKeyVaultUrl"] = BinaryData.FromObjectAsJson(new Dictionary<string, object>()
{
["organizationId"] = "XXX",
["organizationUrl"] = "https://XXX.crmlivetie.com/"}),
},
            };
            ArmOperation<ConnectorResourceFormatResource> lro = await connectorResourceFormat.UpdateAsync(WaitUntil.Completed, data);
            ConnectorResourceFormatResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ConnectorResourceFormatData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Connectors_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_ConnectorsGet()
        {
            // Generated from example definition: specification/customer-insights/resource-manager/Microsoft.CustomerInsights/stable/2017-04-26/examples/ConnectorsGet.json
            // this example is just showing the usage of "Connectors_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ConnectorResourceFormatResource created on azure
            // for more information of creating ConnectorResourceFormatResource, please refer to the document of ConnectorResourceFormatResource
            string subscriptionId = "subid";
            string resourceGroupName = "TestHubRG";
            string hubName = "sdkTestHub";
            string connectorName = "testConnector";
            ResourceIdentifier connectorResourceFormatResourceId = ConnectorResourceFormatResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, hubName, connectorName);
            ConnectorResourceFormatResource connectorResourceFormat = client.GetConnectorResourceFormatResource(connectorResourceFormatResourceId);

            // invoke the operation
            ConnectorResourceFormatResource result = await connectorResourceFormat.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ConnectorResourceFormatData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Connectors_Delete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_ConnectorsDelete()
        {
            // Generated from example definition: specification/customer-insights/resource-manager/Microsoft.CustomerInsights/stable/2017-04-26/examples/ConnectorsDelete.json
            // this example is just showing the usage of "Connectors_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ConnectorResourceFormatResource created on azure
            // for more information of creating ConnectorResourceFormatResource, please refer to the document of ConnectorResourceFormatResource
            string subscriptionId = "subid";
            string resourceGroupName = "TestHubRG";
            string hubName = "sdkTestHub";
            string connectorName = "testConnector";
            ResourceIdentifier connectorResourceFormatResourceId = ConnectorResourceFormatResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, hubName, connectorName);
            ConnectorResourceFormatResource connectorResourceFormat = client.GetConnectorResourceFormatResource(connectorResourceFormatResourceId);

            // invoke the operation
            await connectorResourceFormat.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
