// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.CustomerInsights.Models;

namespace Azure.ResourceManager.CustomerInsights.Samples
{
    public partial class Sample_ConnectorMappingResourceFormatCollection
    {
        // ConnectorMappings_CreateOrUpdate
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_ConnectorMappingsCreateOrUpdate()
        {
            // Generated from example definition: specification/customer-insights/resource-manager/Microsoft.CustomerInsights/stable/2017-04-26/examples/ConnectorMappingsCreateOrUpdate.json
            // this example is just showing the usage of "ConnectorMappings_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ConnectorResourceFormatResource created on azure
            // for more information of creating ConnectorResourceFormatResource, please refer to the document of ConnectorResourceFormatResource
            string subscriptionId = "subid";
            string resourceGroupName = "TestHubRG";
            string hubName = "sdkTestHub";
            string connectorName = "testConnector8858";
            ResourceIdentifier connectorResourceFormatResourceId = ConnectorResourceFormatResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, hubName, connectorName);
            ConnectorResourceFormatResource connectorResourceFormat = client.GetConnectorResourceFormatResource(connectorResourceFormatResourceId);

            // get the collection of this ConnectorMappingResourceFormatResource
            ConnectorMappingResourceFormatCollection collection = connectorResourceFormat.GetConnectorMappingResourceFormats();

            // invoke the operation
            string mappingName = "testMapping12491";
            ConnectorMappingResourceFormatData data = new ConnectorMappingResourceFormatData()
            {
                EntityType = EntityType.Interaction,
                EntityTypeName = "TestInteractionType2967",
                DisplayName = "testMapping12491",
                Description = "Test mapping",
                MappingProperties = new ConnectorMappingProperties(new ConnectorMappingErrorManagement(ErrorManagementType.StopImport)
                {
                    ErrorLimit = 10,
                }, new ConnectorMappingFormat()
                {
                    ColumnDelimiter = "|",
                }, new ConnectorMappingAvailability(5)
                {
                    Frequency = FrequencyType.Hour,
                }, new ConnectorMappingStructure[]
            {
new ConnectorMappingStructure("unknwon1","unknown1")
{
IsEncrypted = false,
},new ConnectorMappingStructure("unknwon2","unknown2")
{
IsEncrypted = true,
}
            }, new ConnectorMappingCompleteOperation()
            {
                CompletionOperationType = CompletionOperationType.DeleteFile,
                DestinationFolder = "fakePath",
            })
                {
                    FolderPath = "http://sample.dne/file",
                    FileFilter = "unknown",
                    HasHeader = false,
                },
            };
            ArmOperation<ConnectorMappingResourceFormatResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, mappingName, data);
            ConnectorMappingResourceFormatResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ConnectorMappingResourceFormatData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ConnectorMappings_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_ConnectorMappingsGet()
        {
            // Generated from example definition: specification/customer-insights/resource-manager/Microsoft.CustomerInsights/stable/2017-04-26/examples/ConnectorMappingsGet.json
            // this example is just showing the usage of "ConnectorMappings_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ConnectorResourceFormatResource created on azure
            // for more information of creating ConnectorResourceFormatResource, please refer to the document of ConnectorResourceFormatResource
            string subscriptionId = "subid";
            string resourceGroupName = "TestHubRG";
            string hubName = "sdkTestHub";
            string connectorName = "testConnector8858";
            ResourceIdentifier connectorResourceFormatResourceId = ConnectorResourceFormatResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, hubName, connectorName);
            ConnectorResourceFormatResource connectorResourceFormat = client.GetConnectorResourceFormatResource(connectorResourceFormatResourceId);

            // get the collection of this ConnectorMappingResourceFormatResource
            ConnectorMappingResourceFormatCollection collection = connectorResourceFormat.GetConnectorMappingResourceFormats();

            // invoke the operation
            string mappingName = "testMapping12491";
            ConnectorMappingResourceFormatResource result = await collection.GetAsync(mappingName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ConnectorMappingResourceFormatData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ConnectorMappings_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_ConnectorMappingsGet()
        {
            // Generated from example definition: specification/customer-insights/resource-manager/Microsoft.CustomerInsights/stable/2017-04-26/examples/ConnectorMappingsGet.json
            // this example is just showing the usage of "ConnectorMappings_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ConnectorResourceFormatResource created on azure
            // for more information of creating ConnectorResourceFormatResource, please refer to the document of ConnectorResourceFormatResource
            string subscriptionId = "subid";
            string resourceGroupName = "TestHubRG";
            string hubName = "sdkTestHub";
            string connectorName = "testConnector8858";
            ResourceIdentifier connectorResourceFormatResourceId = ConnectorResourceFormatResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, hubName, connectorName);
            ConnectorResourceFormatResource connectorResourceFormat = client.GetConnectorResourceFormatResource(connectorResourceFormatResourceId);

            // get the collection of this ConnectorMappingResourceFormatResource
            ConnectorMappingResourceFormatCollection collection = connectorResourceFormat.GetConnectorMappingResourceFormats();

            // invoke the operation
            string mappingName = "testMapping12491";
            bool result = await collection.ExistsAsync(mappingName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // ConnectorMappings_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_ConnectorMappingsGet()
        {
            // Generated from example definition: specification/customer-insights/resource-manager/Microsoft.CustomerInsights/stable/2017-04-26/examples/ConnectorMappingsGet.json
            // this example is just showing the usage of "ConnectorMappings_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ConnectorResourceFormatResource created on azure
            // for more information of creating ConnectorResourceFormatResource, please refer to the document of ConnectorResourceFormatResource
            string subscriptionId = "subid";
            string resourceGroupName = "TestHubRG";
            string hubName = "sdkTestHub";
            string connectorName = "testConnector8858";
            ResourceIdentifier connectorResourceFormatResourceId = ConnectorResourceFormatResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, hubName, connectorName);
            ConnectorResourceFormatResource connectorResourceFormat = client.GetConnectorResourceFormatResource(connectorResourceFormatResourceId);

            // get the collection of this ConnectorMappingResourceFormatResource
            ConnectorMappingResourceFormatCollection collection = connectorResourceFormat.GetConnectorMappingResourceFormats();

            // invoke the operation
            string mappingName = "testMapping12491";
            NullableResponse<ConnectorMappingResourceFormatResource> response = await collection.GetIfExistsAsync(mappingName);
            ConnectorMappingResourceFormatResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                ConnectorMappingResourceFormatData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // ConnectorMappings_ListByConnector
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ConnectorMappingsListByConnector()
        {
            // Generated from example definition: specification/customer-insights/resource-manager/Microsoft.CustomerInsights/stable/2017-04-26/examples/ConnectorMappingsListByConnector.json
            // this example is just showing the usage of "ConnectorMappings_ListByConnector" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ConnectorResourceFormatResource created on azure
            // for more information of creating ConnectorResourceFormatResource, please refer to the document of ConnectorResourceFormatResource
            string subscriptionId = "subid";
            string resourceGroupName = "TestHubRG";
            string hubName = "sdkTestHub";
            string connectorName = "testConnector8858";
            ResourceIdentifier connectorResourceFormatResourceId = ConnectorResourceFormatResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, hubName, connectorName);
            ConnectorResourceFormatResource connectorResourceFormat = client.GetConnectorResourceFormatResource(connectorResourceFormatResourceId);

            // get the collection of this ConnectorMappingResourceFormatResource
            ConnectorMappingResourceFormatCollection collection = connectorResourceFormat.GetConnectorMappingResourceFormats();

            // invoke the operation and iterate over the result
            await foreach (ConnectorMappingResourceFormatResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                ConnectorMappingResourceFormatData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
