// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.CustomerInsights.Models;

namespace Azure.ResourceManager.CustomerInsights.Samples
{
    public partial class Sample_AuthorizationPolicyResourceFormatResource
    {
        // AuthorizationPolicies_CreateOrUpdate
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_AuthorizationPoliciesCreateOrUpdate()
        {
            // Generated from example definition: specification/customer-insights/resource-manager/Microsoft.CustomerInsights/stable/2017-04-26/examples/AuthorizationPoliciesCreateOrUpdate.json
            // this example is just showing the usage of "AuthorizationPolicies_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AuthorizationPolicyResourceFormatResource created on azure
            // for more information of creating AuthorizationPolicyResourceFormatResource, please refer to the document of AuthorizationPolicyResourceFormatResource
            string subscriptionId = "subid";
            string resourceGroupName = "TestHubRG";
            string hubName = "azSdkTestHub";
            string authorizationPolicyName = "testPolicy4222";
            ResourceIdentifier authorizationPolicyResourceFormatResourceId = AuthorizationPolicyResourceFormatResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, hubName, authorizationPolicyName);
            AuthorizationPolicyResourceFormatResource authorizationPolicyResourceFormat = client.GetAuthorizationPolicyResourceFormatResource(authorizationPolicyResourceFormatResourceId);

            // invoke the operation
            AuthorizationPolicyResourceFormatData data = new AuthorizationPolicyResourceFormatData()
            {
                Permissions =
{
PermissionType.Read,PermissionType.Write,PermissionType.Manage
},
            };
            ArmOperation<AuthorizationPolicyResourceFormatResource> lro = await authorizationPolicyResourceFormat.UpdateAsync(WaitUntil.Completed, data);
            AuthorizationPolicyResourceFormatResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AuthorizationPolicyResourceFormatData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // AuthorizationPolicies_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_AuthorizationPoliciesGet()
        {
            // Generated from example definition: specification/customer-insights/resource-manager/Microsoft.CustomerInsights/stable/2017-04-26/examples/AuthorizationPoliciesGet.json
            // this example is just showing the usage of "AuthorizationPolicies_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AuthorizationPolicyResourceFormatResource created on azure
            // for more information of creating AuthorizationPolicyResourceFormatResource, please refer to the document of AuthorizationPolicyResourceFormatResource
            string subscriptionId = "subid";
            string resourceGroupName = "TestHubRG";
            string hubName = "azSdkTestHub";
            string authorizationPolicyName = "testPolicy4222";
            ResourceIdentifier authorizationPolicyResourceFormatResourceId = AuthorizationPolicyResourceFormatResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, hubName, authorizationPolicyName);
            AuthorizationPolicyResourceFormatResource authorizationPolicyResourceFormat = client.GetAuthorizationPolicyResourceFormatResource(authorizationPolicyResourceFormatResourceId);

            // invoke the operation
            AuthorizationPolicyResourceFormatResource result = await authorizationPolicyResourceFormat.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AuthorizationPolicyResourceFormatData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // AuthorizationPolicies_RegeneratePrimaryKey
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task RegeneratePrimaryKey_AuthorizationPoliciesRegeneratePrimaryKey()
        {
            // Generated from example definition: specification/customer-insights/resource-manager/Microsoft.CustomerInsights/stable/2017-04-26/examples/AuthorizationPoliciesRegeneratePrimaryKey.json
            // this example is just showing the usage of "AuthorizationPolicies_RegeneratePrimaryKey" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AuthorizationPolicyResourceFormatResource created on azure
            // for more information of creating AuthorizationPolicyResourceFormatResource, please refer to the document of AuthorizationPolicyResourceFormatResource
            string subscriptionId = "subid";
            string resourceGroupName = "TestHubRG";
            string hubName = "azSdkTestHub";
            string authorizationPolicyName = "testPolicy4222";
            ResourceIdentifier authorizationPolicyResourceFormatResourceId = AuthorizationPolicyResourceFormatResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, hubName, authorizationPolicyName);
            AuthorizationPolicyResourceFormatResource authorizationPolicyResourceFormat = client.GetAuthorizationPolicyResourceFormatResource(authorizationPolicyResourceFormatResourceId);

            // invoke the operation
            AuthorizationPolicy result = await authorizationPolicyResourceFormat.RegeneratePrimaryKeyAsync();

            Console.WriteLine($"Succeeded: {result}");
        }

        // AuthorizationPolicies_RegenerateSecondaryKey
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task RegenerateSecondaryKey_AuthorizationPoliciesRegenerateSecondaryKey()
        {
            // Generated from example definition: specification/customer-insights/resource-manager/Microsoft.CustomerInsights/stable/2017-04-26/examples/AuthorizationPoliciesRegenerateSecondaryKey.json
            // this example is just showing the usage of "AuthorizationPolicies_RegenerateSecondaryKey" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AuthorizationPolicyResourceFormatResource created on azure
            // for more information of creating AuthorizationPolicyResourceFormatResource, please refer to the document of AuthorizationPolicyResourceFormatResource
            string subscriptionId = "subid";
            string resourceGroupName = "TestHubRG";
            string hubName = "azSdkTestHub";
            string authorizationPolicyName = "testPolicy4222";
            ResourceIdentifier authorizationPolicyResourceFormatResourceId = AuthorizationPolicyResourceFormatResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, hubName, authorizationPolicyName);
            AuthorizationPolicyResourceFormatResource authorizationPolicyResourceFormat = client.GetAuthorizationPolicyResourceFormatResource(authorizationPolicyResourceFormatResourceId);

            // invoke the operation
            AuthorizationPolicy result = await authorizationPolicyResourceFormat.RegenerateSecondaryKeyAsync();

            Console.WriteLine($"Succeeded: {result}");
        }
    }
}
