// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CostManagement.Models
{
    /// <summary> Data type to show in view. </summary>
    public readonly partial struct ViewPivotType : IEquatable<ViewPivotType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ViewPivotType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ViewPivotType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DimensionValue = "Dimension";
        private const string TagKeyValue = "TagKey";

        /// <summary> Dimension. </summary>
        public static ViewPivotType Dimension { get; } = new ViewPivotType(DimensionValue);
        /// <summary> TagKey. </summary>
        public static ViewPivotType TagKey { get; } = new ViewPivotType(TagKeyValue);
        /// <summary> Determines if two <see cref="ViewPivotType"/> values are the same. </summary>
        public static bool operator ==(ViewPivotType left, ViewPivotType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ViewPivotType"/> values are not the same. </summary>
        public static bool operator !=(ViewPivotType left, ViewPivotType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ViewPivotType"/>. </summary>
        public static implicit operator ViewPivotType(string value) => new ViewPivotType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ViewPivotType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ViewPivotType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
