// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CostManagement.Models
{
    /// <summary> Metric to use when displaying costs. </summary>
    public readonly partial struct ViewMetricType : IEquatable<ViewMetricType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ViewMetricType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ViewMetricType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ActualCostValue = "ActualCost";
        private const string AmortizedCostValue = "AmortizedCost";
        private const string AhubValue = "AHUB";

        /// <summary> ActualCost. </summary>
        public static ViewMetricType ActualCost { get; } = new ViewMetricType(ActualCostValue);
        /// <summary> AmortizedCost. </summary>
        public static ViewMetricType AmortizedCost { get; } = new ViewMetricType(AmortizedCostValue);
        /// <summary> AHUB. </summary>
        public static ViewMetricType Ahub { get; } = new ViewMetricType(AhubValue);
        /// <summary> Determines if two <see cref="ViewMetricType"/> values are the same. </summary>
        public static bool operator ==(ViewMetricType left, ViewMetricType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ViewMetricType"/> values are not the same. </summary>
        public static bool operator !=(ViewMetricType left, ViewMetricType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ViewMetricType"/>. </summary>
        public static implicit operator ViewMetricType(string value) => new ViewMetricType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ViewMetricType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ViewMetricType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
