// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CostManagement.Models
{
    /// <summary> Chart type of the main view in Cost Analysis. Required. </summary>
    public readonly partial struct ViewChartType : IEquatable<ViewChartType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ViewChartType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ViewChartType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AreaValue = "Area";
        private const string LineValue = "Line";
        private const string StackedColumnValue = "StackedColumn";
        private const string GroupedColumnValue = "GroupedColumn";
        private const string TableValue = "Table";

        /// <summary> Area. </summary>
        public static ViewChartType Area { get; } = new ViewChartType(AreaValue);
        /// <summary> Line. </summary>
        public static ViewChartType Line { get; } = new ViewChartType(LineValue);
        /// <summary> StackedColumn. </summary>
        public static ViewChartType StackedColumn { get; } = new ViewChartType(StackedColumnValue);
        /// <summary> GroupedColumn. </summary>
        public static ViewChartType GroupedColumn { get; } = new ViewChartType(GroupedColumnValue);
        /// <summary> Table. </summary>
        public static ViewChartType Table { get; } = new ViewChartType(TableValue);
        /// <summary> Determines if two <see cref="ViewChartType"/> values are the same. </summary>
        public static bool operator ==(ViewChartType left, ViewChartType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ViewChartType"/> values are not the same. </summary>
        public static bool operator !=(ViewChartType left, ViewChartType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ViewChartType"/>. </summary>
        public static implicit operator ViewChartType(string value) => new ViewChartType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ViewChartType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ViewChartType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
