// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CostManagement.Models
{
    /// <summary> The time frame for pulling data for the export. If custom, then a specific time period must be provided. </summary>
    public readonly partial struct TimeframeType : IEquatable<TimeframeType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="TimeframeType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public TimeframeType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MonthToDateValue = "MonthToDate";
        private const string BillingMonthToDateValue = "BillingMonthToDate";
        private const string TheLastMonthValue = "TheLastMonth";
        private const string TheLastBillingMonthValue = "TheLastBillingMonth";
        private const string WeekToDateValue = "WeekToDate";
        private const string CustomValue = "Custom";

        /// <summary> MonthToDate. </summary>
        public static TimeframeType MonthToDate { get; } = new TimeframeType(MonthToDateValue);
        /// <summary> BillingMonthToDate. </summary>
        public static TimeframeType BillingMonthToDate { get; } = new TimeframeType(BillingMonthToDateValue);
        /// <summary> TheLastMonth. </summary>
        public static TimeframeType TheLastMonth { get; } = new TimeframeType(TheLastMonthValue);
        /// <summary> TheLastBillingMonth. </summary>
        public static TimeframeType TheLastBillingMonth { get; } = new TimeframeType(TheLastBillingMonthValue);
        /// <summary> WeekToDate. </summary>
        public static TimeframeType WeekToDate { get; } = new TimeframeType(WeekToDateValue);
        /// <summary> Custom. </summary>
        public static TimeframeType Custom { get; } = new TimeframeType(CustomValue);
        /// <summary> Determines if two <see cref="TimeframeType"/> values are the same. </summary>
        public static bool operator ==(TimeframeType left, TimeframeType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="TimeframeType"/> values are not the same. </summary>
        public static bool operator !=(TimeframeType left, TimeframeType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="TimeframeType"/>. </summary>
        public static implicit operator TimeframeType(string value) => new TimeframeType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is TimeframeType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(TimeframeType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
