// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.CostManagement.Models
{
    /// <summary> The TenantResourceByExternalCloudProviderTypeDimensionsOptions. </summary>
    public partial class TenantResourceByExternalCloudProviderTypeDimensionsOptions
    {
        /// <summary> Initializes a new instance of <see cref="TenantResourceByExternalCloudProviderTypeDimensionsOptions"/>. </summary>
        /// <param name="externalCloudProviderType"> The external cloud provider type associated with dimension/query operations. This includes 'externalSubscriptions' for linked account and 'externalBillingAccounts' for consolidated account. </param>
        /// <param name="externalCloudProviderId"> This can be '{externalSubscriptionId}' for linked account or '{externalBillingAccountId}' for consolidated account used with dimension/query operations. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="externalCloudProviderId"/> is null. </exception>
        public TenantResourceByExternalCloudProviderTypeDimensionsOptions(ExternalCloudProviderType externalCloudProviderType, string externalCloudProviderId)
        {
            Argument.AssertNotNull(externalCloudProviderId, nameof(externalCloudProviderId));

            ExternalCloudProviderType = externalCloudProviderType;
            ExternalCloudProviderId = externalCloudProviderId;
        }

        /// <summary> Initializes a new instance of <see cref="TenantResourceByExternalCloudProviderTypeDimensionsOptions"/> for deserialization. </summary>
        internal TenantResourceByExternalCloudProviderTypeDimensionsOptions()
        {
        }

        /// <summary> The external cloud provider type associated with dimension/query operations. This includes 'externalSubscriptions' for linked account and 'externalBillingAccounts' for consolidated account. </summary>
        public ExternalCloudProviderType ExternalCloudProviderType { get; }
        /// <summary> This can be '{externalSubscriptionId}' for linked account or '{externalBillingAccountId}' for consolidated account used with dimension/query operations. </summary>
        public string ExternalCloudProviderId { get; }
        /// <summary> May be used to filter dimensions by properties/category, properties/usageStart, properties/usageEnd. Supported operators are 'eq','lt', 'gt', 'le', 'ge'. </summary>
        public string Filter { get; set; }
        /// <summary> May be used to expand the properties/data within a dimension category. By default, data is not included when listing dimensions. </summary>
        public string Expand { get; set; }
        /// <summary> Skiptoken is only used if a previous operation returned a partial result. If a previous response contains a nextLink element, the value of the nextLink element will include a skiptoken parameter that specifies a starting point to use for subsequent calls. </summary>
        public string Skiptoken { get; set; }
        /// <summary> May be used to limit the number of results to the most recent N dimension data. </summary>
        public int? Top { get; set; }
    }
}
