// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.CostManagement.Models
{
    public partial class SingleScopeBenefitRecommendationProperties : IUtf8JsonSerializable, IJsonModel<SingleScopeBenefitRecommendationProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<SingleScopeBenefitRecommendationProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<SingleScopeBenefitRecommendationProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SingleScopeBenefitRecommendationProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SingleScopeBenefitRecommendationProperties)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (options.Format != "W" && Optional.IsDefined(SubscriptionId))
            {
                writer.WritePropertyName("subscriptionId"u8);
                writer.WriteStringValue(SubscriptionId);
            }
            if (options.Format != "W" && Optional.IsDefined(ResourceGroup))
            {
                writer.WritePropertyName("resourceGroup"u8);
                writer.WriteStringValue(ResourceGroup);
            }
        }

        SingleScopeBenefitRecommendationProperties IJsonModel<SingleScopeBenefitRecommendationProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SingleScopeBenefitRecommendationProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SingleScopeBenefitRecommendationProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeSingleScopeBenefitRecommendationProperties(document.RootElement, options);
        }

        internal static SingleScopeBenefitRecommendationProperties DeserializeSingleScopeBenefitRecommendationProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string subscriptionId = default;
            string resourceGroup = default;
            DateTimeOffset? firstConsumptionDate = default;
            DateTimeOffset? lastConsumptionDate = default;
            LookBackPeriod? lookBackPeriod = default;
            int? totalHours = default;
            RecommendationUsageDetails usage = default;
            string armSkuName = default;
            BenefitRecommendationPeriodTerm? term = default;
            BenefitRecommendationUsageGrain? commitmentGranularity = default;
            string currencyCode = default;
            decimal? costWithoutBenefit = default;
            AllSavingsBenefitDetails recommendationDetails = default;
            AllSavingsList allRecommendationDetails = default;
            BenefitRecommendationScope scope = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("subscriptionId"u8))
                {
                    subscriptionId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("resourceGroup"u8))
                {
                    resourceGroup = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("firstConsumptionDate"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    firstConsumptionDate = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("lastConsumptionDate"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lastConsumptionDate = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("lookBackPeriod"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lookBackPeriod = new LookBackPeriod(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("totalHours"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    totalHours = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("usage"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    usage = RecommendationUsageDetails.DeserializeRecommendationUsageDetails(property.Value, options);
                    continue;
                }
                if (property.NameEquals("armSkuName"u8))
                {
                    armSkuName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("term"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    term = new BenefitRecommendationPeriodTerm(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("commitmentGranularity"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    commitmentGranularity = new BenefitRecommendationUsageGrain(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("currencyCode"u8))
                {
                    currencyCode = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("costWithoutBenefit"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    costWithoutBenefit = property.Value.GetDecimal();
                    continue;
                }
                if (property.NameEquals("recommendationDetails"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    recommendationDetails = AllSavingsBenefitDetails.DeserializeAllSavingsBenefitDetails(property.Value, options);
                    continue;
                }
                if (property.NameEquals("allRecommendationDetails"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    allRecommendationDetails = AllSavingsList.DeserializeAllSavingsList(property.Value, options);
                    continue;
                }
                if (property.NameEquals("scope"u8))
                {
                    scope = new BenefitRecommendationScope(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new SingleScopeBenefitRecommendationProperties(
                firstConsumptionDate,
                lastConsumptionDate,
                lookBackPeriod,
                totalHours,
                usage,
                armSkuName,
                term,
                commitmentGranularity,
                currencyCode,
                costWithoutBenefit,
                recommendationDetails,
                allRecommendationDetails,
                scope,
                serializedAdditionalRawData,
                subscriptionId,
                resourceGroup);
        }

        BinaryData IPersistableModel<SingleScopeBenefitRecommendationProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SingleScopeBenefitRecommendationProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(SingleScopeBenefitRecommendationProperties)} does not support writing '{options.Format}' format.");
            }
        }

        SingleScopeBenefitRecommendationProperties IPersistableModel<SingleScopeBenefitRecommendationProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SingleScopeBenefitRecommendationProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeSingleScopeBenefitRecommendationProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(SingleScopeBenefitRecommendationProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<SingleScopeBenefitRecommendationProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
