// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CostManagement.Models
{
    /// <summary> Status of the scheduled action. </summary>
    public readonly partial struct ScheduledActionStatus : IEquatable<ScheduledActionStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ScheduledActionStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ScheduledActionStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DisabledValue = "Disabled";
        private const string EnabledValue = "Enabled";
        private const string ExpiredValue = "Expired";

        /// <summary> Scheduled action is saved but will not be run. </summary>
        public static ScheduledActionStatus Disabled { get; } = new ScheduledActionStatus(DisabledValue);
        /// <summary> Scheduled action is saved and will be run. </summary>
        public static ScheduledActionStatus Enabled { get; } = new ScheduledActionStatus(EnabledValue);
        /// <summary> Scheduled action is expired. </summary>
        public static ScheduledActionStatus Expired { get; } = new ScheduledActionStatus(ExpiredValue);
        /// <summary> Determines if two <see cref="ScheduledActionStatus"/> values are the same. </summary>
        public static bool operator ==(ScheduledActionStatus left, ScheduledActionStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ScheduledActionStatus"/> values are not the same. </summary>
        public static bool operator !=(ScheduledActionStatus left, ScheduledActionStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ScheduledActionStatus"/>. </summary>
        public static implicit operator ScheduledActionStatus(string value) => new ScheduledActionStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ScheduledActionStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ScheduledActionStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
