// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CostManagement.Models
{
    /// <summary> Kind of the scheduled action. </summary>
    public readonly partial struct ScheduledActionKind : IEquatable<ScheduledActionKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ScheduledActionKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ScheduledActionKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EmailValue = "Email";
        private const string InsightAlertValue = "InsightAlert";

        /// <summary> Cost analysis data will be emailed. </summary>
        public static ScheduledActionKind Email { get; } = new ScheduledActionKind(EmailValue);
        /// <summary> Cost anomaly information will be emailed. Available only on subscription scope at daily frequency. If no anomaly is detected on the resource, an email won't be sent. </summary>
        public static ScheduledActionKind InsightAlert { get; } = new ScheduledActionKind(InsightAlertValue);
        /// <summary> Determines if two <see cref="ScheduledActionKind"/> values are the same. </summary>
        public static bool operator ==(ScheduledActionKind left, ScheduledActionKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ScheduledActionKind"/> values are not the same. </summary>
        public static bool operator !=(ScheduledActionKind left, ScheduledActionKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ScheduledActionKind"/>. </summary>
        public static implicit operator ScheduledActionKind(string value) => new ScheduledActionKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ScheduledActionKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ScheduledActionKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
