// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CostManagement.Models
{
    /// <summary> Days of Week. </summary>
    public readonly partial struct ScheduledActionDaysOfWeek : IEquatable<ScheduledActionDaysOfWeek>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ScheduledActionDaysOfWeek"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ScheduledActionDaysOfWeek(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MondayValue = "Monday";
        private const string TuesdayValue = "Tuesday";
        private const string WednesdayValue = "Wednesday";
        private const string ThursdayValue = "Thursday";
        private const string FridayValue = "Friday";
        private const string SaturdayValue = "Saturday";
        private const string SundayValue = "Sunday";

        /// <summary> Monday. </summary>
        public static ScheduledActionDaysOfWeek Monday { get; } = new ScheduledActionDaysOfWeek(MondayValue);
        /// <summary> Tuesday. </summary>
        public static ScheduledActionDaysOfWeek Tuesday { get; } = new ScheduledActionDaysOfWeek(TuesdayValue);
        /// <summary> Wednesday. </summary>
        public static ScheduledActionDaysOfWeek Wednesday { get; } = new ScheduledActionDaysOfWeek(WednesdayValue);
        /// <summary> Thursday. </summary>
        public static ScheduledActionDaysOfWeek Thursday { get; } = new ScheduledActionDaysOfWeek(ThursdayValue);
        /// <summary> Friday. </summary>
        public static ScheduledActionDaysOfWeek Friday { get; } = new ScheduledActionDaysOfWeek(FridayValue);
        /// <summary> Saturday. </summary>
        public static ScheduledActionDaysOfWeek Saturday { get; } = new ScheduledActionDaysOfWeek(SaturdayValue);
        /// <summary> Sunday. </summary>
        public static ScheduledActionDaysOfWeek Sunday { get; } = new ScheduledActionDaysOfWeek(SundayValue);
        /// <summary> Determines if two <see cref="ScheduledActionDaysOfWeek"/> values are the same. </summary>
        public static bool operator ==(ScheduledActionDaysOfWeek left, ScheduledActionDaysOfWeek right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ScheduledActionDaysOfWeek"/> values are not the same. </summary>
        public static bool operator !=(ScheduledActionDaysOfWeek left, ScheduledActionDaysOfWeek right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ScheduledActionDaysOfWeek"/>. </summary>
        public static implicit operator ScheduledActionDaysOfWeek(string value) => new ScheduledActionDaysOfWeek(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ScheduledActionDaysOfWeek other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ScheduledActionDaysOfWeek other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
