// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CostManagement.Models
{
    /// <summary> The CSV file from the reportUrl blob link consists of reservation usage data with the following schema at daily granularity. </summary>
    public readonly partial struct ReservationReportSchema : IEquatable<ReservationReportSchema>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ReservationReportSchema"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ReservationReportSchema(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InstanceFlexibilityGroupValue = "InstanceFlexibilityGroup";
        private const string InstanceFlexibilityRatioValue = "InstanceFlexibilityRatio";
        private const string InstanceIdValue = "InstanceId";
        private const string KindValue = "Kind";
        private const string ReservationIdValue = "ReservationId";
        private const string ReservationOrderIdValue = "ReservationOrderId";
        private const string ReservedHoursValue = "ReservedHours";
        private const string SkuNameValue = "SkuName";
        private const string TotalReservedQuantityValue = "TotalReservedQuantity";
        private const string UsageDateValue = "UsageDate";
        private const string UsedHoursValue = "UsedHours";

        /// <summary> InstanceFlexibilityGroup. </summary>
        public static ReservationReportSchema InstanceFlexibilityGroup { get; } = new ReservationReportSchema(InstanceFlexibilityGroupValue);
        /// <summary> InstanceFlexibilityRatio. </summary>
        public static ReservationReportSchema InstanceFlexibilityRatio { get; } = new ReservationReportSchema(InstanceFlexibilityRatioValue);
        /// <summary> InstanceId. </summary>
        public static ReservationReportSchema InstanceId { get; } = new ReservationReportSchema(InstanceIdValue);
        /// <summary> Kind. </summary>
        public static ReservationReportSchema Kind { get; } = new ReservationReportSchema(KindValue);
        /// <summary> ReservationId. </summary>
        public static ReservationReportSchema ReservationId { get; } = new ReservationReportSchema(ReservationIdValue);
        /// <summary> ReservationOrderId. </summary>
        public static ReservationReportSchema ReservationOrderId { get; } = new ReservationReportSchema(ReservationOrderIdValue);
        /// <summary> ReservedHours. </summary>
        public static ReservationReportSchema ReservedHours { get; } = new ReservationReportSchema(ReservedHoursValue);
        /// <summary> SkuName. </summary>
        public static ReservationReportSchema SkuName { get; } = new ReservationReportSchema(SkuNameValue);
        /// <summary> TotalReservedQuantity. </summary>
        public static ReservationReportSchema TotalReservedQuantity { get; } = new ReservationReportSchema(TotalReservedQuantityValue);
        /// <summary> UsageDate. </summary>
        public static ReservationReportSchema UsageDate { get; } = new ReservationReportSchema(UsageDateValue);
        /// <summary> UsedHours. </summary>
        public static ReservationReportSchema UsedHours { get; } = new ReservationReportSchema(UsedHoursValue);
        /// <summary> Determines if two <see cref="ReservationReportSchema"/> values are the same. </summary>
        public static bool operator ==(ReservationReportSchema left, ReservationReportSchema right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ReservationReportSchema"/> values are not the same. </summary>
        public static bool operator !=(ReservationReportSchema left, ReservationReportSchema right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ReservationReportSchema"/>. </summary>
        public static implicit operator ReservationReportSchema(string value) => new ReservationReportSchema(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ReservationReportSchema other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ReservationReportSchema other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
