// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CostManagement.Models
{
    /// <summary> The time frame for pulling data for the report. If custom, then a specific time period must be provided. </summary>
    public readonly partial struct ReportTimeframeType : IEquatable<ReportTimeframeType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ReportTimeframeType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ReportTimeframeType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string WeekToDateValue = "WeekToDate";
        private const string MonthToDateValue = "MonthToDate";
        private const string YearToDateValue = "YearToDate";
        private const string CustomValue = "Custom";

        /// <summary> WeekToDate. </summary>
        public static ReportTimeframeType WeekToDate { get; } = new ReportTimeframeType(WeekToDateValue);
        /// <summary> MonthToDate. </summary>
        public static ReportTimeframeType MonthToDate { get; } = new ReportTimeframeType(MonthToDateValue);
        /// <summary> YearToDate. </summary>
        public static ReportTimeframeType YearToDate { get; } = new ReportTimeframeType(YearToDateValue);
        /// <summary> Custom. </summary>
        public static ReportTimeframeType Custom { get; } = new ReportTimeframeType(CustomValue);
        /// <summary> Determines if two <see cref="ReportTimeframeType"/> values are the same. </summary>
        public static bool operator ==(ReportTimeframeType left, ReportTimeframeType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ReportTimeframeType"/> values are not the same. </summary>
        public static bool operator !=(ReportTimeframeType left, ReportTimeframeType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ReportTimeframeType"/>. </summary>
        public static implicit operator ReportTimeframeType(string value) => new ReportTimeframeType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ReportTimeframeType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ReportTimeframeType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
