// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CostManagement.Models
{
    /// <summary> The granularity of rows in the report. </summary>
    public readonly partial struct ReportGranularityType : IEquatable<ReportGranularityType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ReportGranularityType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ReportGranularityType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DailyValue = "Daily";
        private const string MonthlyValue = "Monthly";

        /// <summary> Daily. </summary>
        public static ReportGranularityType Daily { get; } = new ReportGranularityType(DailyValue);
        /// <summary> Monthly. </summary>
        public static ReportGranularityType Monthly { get; } = new ReportGranularityType(MonthlyValue);
        /// <summary> Determines if two <see cref="ReportGranularityType"/> values are the same. </summary>
        public static bool operator ==(ReportGranularityType left, ReportGranularityType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ReportGranularityType"/> values are not the same. </summary>
        public static bool operator !=(ReportGranularityType left, ReportGranularityType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ReportGranularityType"/>. </summary>
        public static implicit operator ReportGranularityType(string value) => new ReportGranularityType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ReportGranularityType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ReportGranularityType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
