// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CostManagement.Models
{
    /// <summary> Direction of sort. </summary>
    public readonly partial struct ReportConfigSortingType : IEquatable<ReportConfigSortingType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ReportConfigSortingType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ReportConfigSortingType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AscendingValue = "Ascending";
        private const string DescendingValue = "Descending";

        /// <summary> Ascending. </summary>
        public static ReportConfigSortingType Ascending { get; } = new ReportConfigSortingType(AscendingValue);
        /// <summary> Descending. </summary>
        public static ReportConfigSortingType Descending { get; } = new ReportConfigSortingType(DescendingValue);
        /// <summary> Determines if two <see cref="ReportConfigSortingType"/> values are the same. </summary>
        public static bool operator ==(ReportConfigSortingType left, ReportConfigSortingType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ReportConfigSortingType"/> values are not the same. </summary>
        public static bool operator !=(ReportConfigSortingType left, ReportConfigSortingType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ReportConfigSortingType"/>. </summary>
        public static implicit operator ReportConfigSortingType(string value) => new ReportConfigSortingType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ReportConfigSortingType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ReportConfigSortingType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
