// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.CostManagement.Models
{
    /// <summary> On-demand charges between firstConsumptionDate and lastConsumptionDate that were used for computing benefit recommendations. </summary>
    public partial class RecommendationUsageDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RecommendationUsageDetails"/>. </summary>
        public RecommendationUsageDetails()
        {
            Charges = new ChangeTrackingList<decimal>();
        }

        /// <summary> Initializes a new instance of <see cref="RecommendationUsageDetails"/>. </summary>
        /// <param name="usageGrain"> The grain of the usage. Supported values: 'Hourly'. </param>
        /// <param name="charges"> On-demand charges for each hour between firstConsumptionDate and lastConsumptionDate that were used for computing benefit recommendations. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RecommendationUsageDetails(BenefitRecommendationUsageGrain? usageGrain, IReadOnlyList<decimal> charges, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            UsageGrain = usageGrain;
            Charges = charges;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The grain of the usage. Supported values: 'Hourly'. </summary>
        public BenefitRecommendationUsageGrain? UsageGrain { get; set; }
        /// <summary> On-demand charges for each hour between firstConsumptionDate and lastConsumptionDate that were used for computing benefit recommendations. </summary>
        public IReadOnlyList<decimal> Charges { get; }
    }
}
