// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.CostManagement.Models
{
    public partial class RecommendationUsageDetails : IUtf8JsonSerializable, IJsonModel<RecommendationUsageDetails>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<RecommendationUsageDetails>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<RecommendationUsageDetails>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RecommendationUsageDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(RecommendationUsageDetails)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(UsageGrain))
            {
                writer.WritePropertyName("usageGrain"u8);
                writer.WriteStringValue(UsageGrain.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(Charges))
            {
                writer.WritePropertyName("charges"u8);
                writer.WriteStartArray();
                foreach (var item in Charges)
                {
                    writer.WriteNumberValue(item);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        RecommendationUsageDetails IJsonModel<RecommendationUsageDetails>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RecommendationUsageDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(RecommendationUsageDetails)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeRecommendationUsageDetails(document.RootElement, options);
        }

        internal static RecommendationUsageDetails DeserializeRecommendationUsageDetails(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            BenefitRecommendationUsageGrain? usageGrain = default;
            IReadOnlyList<decimal> charges = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("usageGrain"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    usageGrain = new BenefitRecommendationUsageGrain(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("charges"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<decimal> array = new List<decimal>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetDecimal());
                    }
                    charges = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new RecommendationUsageDetails(usageGrain, charges ?? new ChangeTrackingList<decimal>(), serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<RecommendationUsageDetails>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RecommendationUsageDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(RecommendationUsageDetails)} does not support writing '{options.Format}' format.");
            }
        }

        RecommendationUsageDetails IPersistableModel<RecommendationUsageDetails>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RecommendationUsageDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeRecommendationUsageDetails(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(RecommendationUsageDetails)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<RecommendationUsageDetails>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
