// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CostManagement.Models
{
    /// <summary> The operator to use for comparison. </summary>
    public readonly partial struct QueryOperatorType : IEquatable<QueryOperatorType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="QueryOperatorType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public QueryOperatorType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InValue = "In";

        /// <summary> In. </summary>
        public static QueryOperatorType In { get; } = new QueryOperatorType(InValue);
        /// <summary> Determines if two <see cref="QueryOperatorType"/> values are the same. </summary>
        public static bool operator ==(QueryOperatorType left, QueryOperatorType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="QueryOperatorType"/> values are not the same. </summary>
        public static bool operator !=(QueryOperatorType left, QueryOperatorType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="QueryOperatorType"/>. </summary>
        public static implicit operator QueryOperatorType(string value) => new QueryOperatorType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is QueryOperatorType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(QueryOperatorType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
