// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CostManagement.Models
{
    /// <summary> Enum representing the status of an async operation. </summary>
    public readonly partial struct OperationStatusType : IEquatable<OperationStatusType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="OperationStatusType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public OperationStatusType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RunningValue = "Running";
        private const string CompleteValue = "Complete";
        private const string FailedValue = "Failed";
        private const string CompletedValue = "Completed";

        /// <summary> Running. </summary>
        public static OperationStatusType Running { get; } = new OperationStatusType(RunningValue);
        /// <summary> Complete. </summary>
        public static OperationStatusType Complete { get; } = new OperationStatusType(CompleteValue);
        /// <summary> Failed. </summary>
        public static OperationStatusType Failed { get; } = new OperationStatusType(FailedValue);
        /// <summary> Completed. </summary>
        public static OperationStatusType Completed { get; } = new OperationStatusType(CompletedValue);
        /// <summary> Determines if two <see cref="OperationStatusType"/> values are the same. </summary>
        public static bool operator ==(OperationStatusType left, OperationStatusType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="OperationStatusType"/> values are not the same. </summary>
        public static bool operator !=(OperationStatusType left, OperationStatusType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="OperationStatusType"/>. </summary>
        public static implicit operator OperationStatusType(string value) => new OperationStatusType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is OperationStatusType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(OperationStatusType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
