// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.CostManagement.Models
{
    /// <summary> The status of the long running operation. </summary>
    public partial class OperationStatus
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="OperationStatus"/>. </summary>
        internal OperationStatus()
        {
        }

        /// <summary> Initializes a new instance of <see cref="OperationStatus"/>. </summary>
        /// <param name="status"> The status of the long running operation. </param>
        /// <param name="reportUri"> The CSV file from the reportUrl blob link consists of reservation usage data with the following schema at daily granularity. </param>
        /// <param name="validUntil"> The time at which report URL becomes invalid. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal OperationStatus(OperationStatusType? status, ReservationReportSchema? reportUri, DateTimeOffset? validUntil, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Status = status;
            ReportUri = reportUri;
            ValidUntil = validUntil;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The status of the long running operation. </summary>
        public OperationStatusType? Status { get; }
        /// <summary> The CSV file from the reportUrl blob link consists of reservation usage data with the following schema at daily granularity. </summary>
        public ReservationReportSchema? ReportUri { get; }
        /// <summary> The time at which report URL becomes invalid. </summary>
        public DateTimeOffset? ValidUntil { get; }
    }
}
