// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CostManagement.Models
{
    /// <summary> The number of days used to look back. </summary>
    public readonly partial struct LookBackPeriod : IEquatable<LookBackPeriod>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="LookBackPeriod"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public LookBackPeriod(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string Last7DaysValue = "Last7Days";
        private const string Last30DaysValue = "Last30Days";
        private const string Last60DaysValue = "Last60Days";

        /// <summary> 7 days used to look back. </summary>
        public static LookBackPeriod Last7Days { get; } = new LookBackPeriod(Last7DaysValue);
        /// <summary> 30 days used to look back. </summary>
        public static LookBackPeriod Last30Days { get; } = new LookBackPeriod(Last30DaysValue);
        /// <summary> 60 days used to look back. </summary>
        public static LookBackPeriod Last60Days { get; } = new LookBackPeriod(Last60DaysValue);
        /// <summary> Determines if two <see cref="LookBackPeriod"/> values are the same. </summary>
        public static bool operator ==(LookBackPeriod left, LookBackPeriod right) => left.Equals(right);
        /// <summary> Determines if two <see cref="LookBackPeriod"/> values are not the same. </summary>
        public static bool operator !=(LookBackPeriod left, LookBackPeriod right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="LookBackPeriod"/>. </summary>
        public static implicit operator LookBackPeriod(string value) => new LookBackPeriod(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is LookBackPeriod other && Equals(other);
        /// <inheritdoc />
        public bool Equals(LookBackPeriod other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
