// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CostManagement.Models
{
    /// <summary> The granularity of rows in the export. Currently only 'Daily' is supported. </summary>
    public readonly partial struct GranularityType : IEquatable<GranularityType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="GranularityType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public GranularityType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DailyValue = "Daily";

        /// <summary> Daily. </summary>
        public static GranularityType Daily { get; } = new GranularityType(DailyValue);
        /// <summary> Determines if two <see cref="GranularityType"/> values are the same. </summary>
        public static bool operator ==(GranularityType left, GranularityType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="GranularityType"/> values are not the same. </summary>
        public static bool operator !=(GranularityType left, GranularityType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="GranularityType"/>. </summary>
        public static implicit operator GranularityType(string value) => new GranularityType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is GranularityType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(GranularityType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
