// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CostManagement.Models
{
    /// <summary> The name of the aggregation function to use. </summary>
    public readonly partial struct FunctionType : IEquatable<FunctionType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FunctionType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FunctionType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SumValue = "Sum";

        /// <summary> Sum. </summary>
        public static FunctionType Sum { get; } = new FunctionType(SumValue);
        /// <summary> Determines if two <see cref="FunctionType"/> values are the same. </summary>
        public static bool operator ==(FunctionType left, FunctionType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FunctionType"/> values are not the same. </summary>
        public static bool operator !=(FunctionType left, FunctionType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FunctionType"/>. </summary>
        public static implicit operator FunctionType(string value) => new FunctionType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FunctionType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FunctionType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
