// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CostManagement.Models
{
    /// <summary> The type of the forecast. </summary>
    public readonly partial struct ForecastType : IEquatable<ForecastType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ForecastType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ForecastType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UsageValue = "Usage";
        private const string ActualCostValue = "ActualCost";
        private const string AmortizedCostValue = "AmortizedCost";

        /// <summary> Usage. </summary>
        public static ForecastType Usage { get; } = new ForecastType(UsageValue);
        /// <summary> ActualCost. </summary>
        public static ForecastType ActualCost { get; } = new ForecastType(ActualCostValue);
        /// <summary> AmortizedCost. </summary>
        public static ForecastType AmortizedCost { get; } = new ForecastType(AmortizedCostValue);
        /// <summary> Determines if two <see cref="ForecastType"/> values are the same. </summary>
        public static bool operator ==(ForecastType left, ForecastType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ForecastType"/> values are not the same. </summary>
        public static bool operator !=(ForecastType left, ForecastType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ForecastType"/>. </summary>
        public static implicit operator ForecastType(string value) => new ForecastType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ForecastType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ForecastType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
