// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CostManagement.Models
{
    /// <summary> The time frame for pulling data for the forecast. </summary>
    public readonly partial struct ForecastTimeframe : IEquatable<ForecastTimeframe>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ForecastTimeframe"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ForecastTimeframe(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CustomValue = "Custom";

        /// <summary> Custom. </summary>
        public static ForecastTimeframe Custom { get; } = new ForecastTimeframe(CustomValue);
        /// <summary> Determines if two <see cref="ForecastTimeframe"/> values are the same. </summary>
        public static bool operator ==(ForecastTimeframe left, ForecastTimeframe right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ForecastTimeframe"/> values are not the same. </summary>
        public static bool operator !=(ForecastTimeframe left, ForecastTimeframe right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ForecastTimeframe"/>. </summary>
        public static implicit operator ForecastTimeframe(string value) => new ForecastTimeframe(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ForecastTimeframe other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ForecastTimeframe other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
