// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.CostManagement.Models
{
    /// <summary> Has time period for pulling data for the forecast. </summary>
    public partial class ForecastTimePeriod
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ForecastTimePeriod"/>. </summary>
        /// <param name="from"> The start date to pull data from. </param>
        /// <param name="to"> The end date to pull data to. </param>
        public ForecastTimePeriod(DateTimeOffset @from, DateTimeOffset to)
        {
            From = @from;
            To = to;
        }

        /// <summary> Initializes a new instance of <see cref="ForecastTimePeriod"/>. </summary>
        /// <param name="from"> The start date to pull data from. </param>
        /// <param name="to"> The end date to pull data to. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ForecastTimePeriod(DateTimeOffset @from, DateTimeOffset to, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            From = @from;
            To = to;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ForecastTimePeriod"/> for deserialization. </summary>
        internal ForecastTimePeriod()
        {
        }

        /// <summary> The start date to pull data from. </summary>
        public DateTimeOffset From { get; }
        /// <summary> The end date to pull data to. </summary>
        public DateTimeOffset To { get; }
    }
}
