// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CostManagement.Models
{
    /// <summary> The operator to use for comparison. </summary>
    public readonly partial struct ForecastOperatorType : IEquatable<ForecastOperatorType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ForecastOperatorType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ForecastOperatorType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InValue = "In";

        /// <summary> In. </summary>
        public static ForecastOperatorType In { get; } = new ForecastOperatorType(InValue);
        /// <summary> Determines if two <see cref="ForecastOperatorType"/> values are the same. </summary>
        public static bool operator ==(ForecastOperatorType left, ForecastOperatorType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ForecastOperatorType"/> values are not the same. </summary>
        public static bool operator !=(ForecastOperatorType left, ForecastOperatorType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ForecastOperatorType"/>. </summary>
        public static implicit operator ForecastOperatorType(string value) => new ForecastOperatorType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ForecastOperatorType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ForecastOperatorType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
